function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { useMemo, useCallback, useState } from 'react';
import { useUpdateEffect } from '../../../services';
import { IS_JEST_ENVIRONMENT } from '../../../utils';
var DEFAULT_COLUMN_WIDTH = 100;
export var useDefaultColumnWidth = function useDefaultColumnWidth(gridWidth, leadingControlColumns, trailingControlColumns, columns) {
  var defaultColumnWidth = useMemo(function () {
    if (IS_JEST_ENVIRONMENT) return DEFAULT_COLUMN_WIDTH;
    if (gridWidth === 0) return null; // we can't tell what size to compute yet

    var controlColumnWidths = [].concat(_toConsumableArray(leadingControlColumns), _toConsumableArray(trailingControlColumns)).reduce(function (claimedWidth, controlColumn) {
      return claimedWidth + controlColumn.width;
    }, 0);
    var columnsWithWidths = columns.filter(doesColumnHaveAnInitialWidth);
    var definedColumnsWidth = columnsWithWidths.reduce(function (claimedWidth, column) {
      return claimedWidth + column.initialWidth;
    }, 0);
    var claimedWidth = controlColumnWidths + definedColumnsWidth;
    var widthToFill = gridWidth - claimedWidth;
    var unsizedColumnCount = columns.length - columnsWithWidths.length;
    if (unsizedColumnCount === 0) {
      return DEFAULT_COLUMN_WIDTH;
    }
    return Math.max(widthToFill / unsizedColumnCount, DEFAULT_COLUMN_WIDTH);
  }, [gridWidth, columns, leadingControlColumns, trailingControlColumns]);
  return defaultColumnWidth;
};
export var doesColumnHaveAnInitialWidth = function doesColumnHaveAnInitialWidth(column) {
  return column.hasOwnProperty('initialWidth') && column.initialWidth != null;
};
export var useColumnWidths = function useColumnWidths(_ref) {
  var columns = _ref.columns,
    leadingControlColumns = _ref.leadingControlColumns,
    trailingControlColumns = _ref.trailingControlColumns,
    defaultColumnWidth = _ref.defaultColumnWidth,
    onColumnResize = _ref.onColumnResize;
  var computeColumnWidths = useCallback(function () {
    return columns.filter(doesColumnHaveAnInitialWidth).reduce(function (initialWidths, column) {
      return _objectSpread(_objectSpread({}, initialWidths), {}, _defineProperty({}, column.id, column.initialWidth));
    }, {});
  }, [columns]);

  // Passes initializer function for performance, so computing only runs once on init
  // @see https://react.dev/reference/react/useState#examples-initializer
  var _useState = useState(computeColumnWidths),
    _useState2 = _slicedToArray(_useState, 2),
    columnWidths = _useState2[0],
    setColumnWidths = _useState2[1];
  useUpdateEffect(function () {
    setColumnWidths(computeColumnWidths());
  }, [computeColumnWidths]);
  var setColumnWidth = useCallback(function (columnId, width) {
    setColumnWidths(function (prevColumnWidths) {
      return _objectSpread(_objectSpread({}, prevColumnWidths), {}, _defineProperty({}, columnId, width));
    });
    onColumnResize === null || onColumnResize === void 0 || onColumnResize({
      columnId: columnId,
      width: width
    });
  }, [onColumnResize]);

  // Used by react-window to determine actual column widths
  var getColumnWidth = useCallback(function (index) {
    // Leading control columns
    if (leadingControlColumns.length && index < leadingControlColumns.length) {
      return leadingControlColumns[index].width;
    }
    // Trailing control columns
    if (trailingControlColumns.length && index >= leadingControlColumns.length + columns.length) {
      return trailingControlColumns[index - leadingControlColumns.length - columns.length].width;
    }
    // Normal data columns
    var columnId = columns.length > 0 ? columns[index - leadingControlColumns.length].id : '';
    return columnWidths[columnId] || defaultColumnWidth || DEFAULT_COLUMN_WIDTH;
  }, [columns, leadingControlColumns, trailingControlColumns, columnWidths, defaultColumnWidth]);
  return {
    columnWidths: columnWidths,
    setColumnWidth: setColumnWidth,
    getColumnWidth: getColumnWidth
  };
};