/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, mathWithUnits } from '../../../global_styling';
export var euiDataGridScrollBarStyles = function euiDataGridScrollBarStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;

  // Note that 'borders' *must* be rendered with inset box-shadow, because actual
  // `border` CSS will affect the relative position of the child scroll bar overlays
  // and cause them to be off by the width of the border
  var borderWidth = euiTheme.border.width.thin;
  var borderColor = euiTheme.border.color;
  return {
    euiDataGrid__scrollOverlay: /*#__PURE__*/css("position:absolute;inset:0;", logicalCSS('top', "-".concat(borderWidth)), "pointer-events:none;box-shadow:inset 0 0 0 ", borderWidth, " ", borderColor, ";.euiDataGrid--bordersHorizontal &{box-shadow:inset 0 -", mathWithUnits(borderWidth, function (x) {
      return x * 2;
    }), " 0 -", borderWidth, " ", borderColor, ";};label:euiDataGrid__scrollOverlay;"),
    // Ensure the horizontal scrollbar has a top border
    euiDataGrid__scrollBarOverlayBottom: /*#__PURE__*/css("position:absolute;inset-inline:0;", logicalCSS('height', borderWidth), " background-color:", borderColor, ";;label:euiDataGrid__scrollBarOverlayBottom;"),
    // Ensure the vertical scrollbar has a left border
    euiDataGrid__scrollBarOverlayRight: /*#__PURE__*/css("position:absolute;", logicalCSS('width', borderWidth), " background-color:", borderColor, ";;label:euiDataGrid__scrollBarOverlayRight;")
    // Note: Scroll bar border positions are set via JS inline style, since
    // JS has access to the exact OS scrollbar width/height and CSS doesn't
  };
};