var _excluded = ["className", "onRefreshChange", "intervalUnits", "isDisabled", "isPaused", "refreshInterval", "minInterval", "readOnly"],
  _excluded2 = ["className", "onRefreshChange", "intervalUnits", "isDisabled", "isPaused", "refreshInterval", "minInterval", "shortHand", "size", "color"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { EuiFieldText } from '../../form';
import { EuiButtonEmpty } from '../../button/button_empty/button_empty';
import { EuiInputPopover, EuiPopover } from '../../popover';
import { useEuiI18n } from '../../i18n';
import { usePrettyInterval } from '../super_date_picker/pretty_interval';
import { EuiRefreshInterval } from './refresh_interval';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiAutoRefresh = function EuiAutoRefresh(_ref) {
  var className = _ref.className,
    onRefreshChange = _ref.onRefreshChange,
    intervalUnits = _ref.intervalUnits,
    isDisabled = _ref.isDisabled,
    _ref$isPaused = _ref.isPaused,
    isPaused = _ref$isPaused === void 0 ? true : _ref$isPaused,
    _ref$refreshInterval = _ref.refreshInterval,
    refreshInterval = _ref$refreshInterval === void 0 ? 1000 : _ref$refreshInterval,
    _ref$minInterval = _ref.minInterval,
    minInterval = _ref$minInterval === void 0 ? 0 : _ref$minInterval,
    _ref$readOnly = _ref.readOnly,
    readOnly = _ref$readOnly === void 0 ? true : _ref$readOnly,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiAutoRefresh', className);
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isPopoverOpen = _useState2[0],
    setIsPopoverOpen = _useState2[1];
  var autoRefeshLabel = useEuiI18n('euiAutoRefresh.autoRefreshLabel', 'Auto refresh');
  return ___EmotionJSX(EuiInputPopover, {
    className: classes,
    fullWidth: rest.fullWidth,
    input: ___EmotionJSX(EuiFieldText, _extends({
      "aria-label": autoRefeshLabel,
      onClick: function onClick() {
        return setIsPopoverOpen(function (isOpen) {
          return !isOpen;
        });
      },
      prepend: ___EmotionJSX(EuiButtonEmpty, {
        className: "euiFormControlLayout__prepend",
        onClick: function onClick() {
          return setIsPopoverOpen(function (isOpen) {
            return !isOpen;
          });
        },
        size: "s",
        color: "text",
        iconType: "timeRefresh",
        isDisabled: isDisabled
      }, ___EmotionJSX("strong", null, ___EmotionJSX("small", null, autoRefeshLabel))),
      readOnly: readOnly,
      disabled: isDisabled,
      value: usePrettyInterval(Boolean(isPaused), refreshInterval, {
        unit: intervalUnits
      })
    }, rest)),
    isOpen: isPopoverOpen,
    closePopover: function closePopover() {
      setIsPopoverOpen(false);
    }
  }, ___EmotionJSX(EuiRefreshInterval, {
    onRefreshChange: onRefreshChange,
    isPaused: isPaused,
    refreshInterval: refreshInterval,
    minInterval: minInterval,
    intervalUnits: intervalUnits
  }));
};
EuiAutoRefresh.propTypes = {
  /**
     * Is refresh paused or running.
     */
  isPaused: PropTypes.bool,
  refreshInterval: PropTypes.number,
  minInterval: PropTypes.number,
  /**
     * By default, refresh interval units will be rounded up to next largest unit of time
     * (for example, 90 seconds will become 2m).
     *
     * If you do not want this behavior, you can manually control the rendered unit via this prop.
     */
  intervalUnits: PropTypes.any,
  /**
     * Passes back the updated state of `isPaused`, `refreshInterval`, and `intervalUnits`.
     */
  onRefreshChange: PropTypes.func.isRequired,
  isDisabled: PropTypes.bool,
  /**
     * The input is `readOnly` by default because the input value is handled by the popover form.
     */
  readOnly: PropTypes.any
};
export var EuiAutoRefreshButton = function EuiAutoRefreshButton(_ref2) {
  var className = _ref2.className,
    onRefreshChange = _ref2.onRefreshChange,
    intervalUnits = _ref2.intervalUnits,
    isDisabled = _ref2.isDisabled,
    _ref2$isPaused = _ref2.isPaused,
    isPaused = _ref2$isPaused === void 0 ? true : _ref2$isPaused,
    _ref2$refreshInterval = _ref2.refreshInterval,
    refreshInterval = _ref2$refreshInterval === void 0 ? 1000 : _ref2$refreshInterval,
    _ref2$minInterval = _ref2.minInterval,
    minInterval = _ref2$minInterval === void 0 ? 0 : _ref2$minInterval,
    _ref2$shortHand = _ref2.shortHand,
    shortHand = _ref2$shortHand === void 0 ? false : _ref2$shortHand,
    _ref2$size = _ref2.size,
    size = _ref2$size === void 0 ? 's' : _ref2$size,
    _ref2$color = _ref2.color,
    color = _ref2$color === void 0 ? 'text' : _ref2$color,
    rest = _objectWithoutProperties(_ref2, _excluded2);
  var _useState3 = useState(false),
    _useState4 = _slicedToArray(_useState3, 2),
    isPopoverOpen = _useState4[0],
    setIsPopoverOpen = _useState4[1];
  var classes = classNames('euiAutoRefreshButton', className);
  var autoRefeshLabelOff = useEuiI18n('euiAutoRefresh.buttonLabelOff', 'Auto refresh is off');
  var autoRefeshLabelOn = useEuiI18n('euiAutoRefresh.buttonLabelOn', 'Auto refresh is on and set to {prettyInterval}', {
    prettyInterval: usePrettyInterval(Boolean(isPaused), refreshInterval, {
      unit: intervalUnits
    })
  });
  return ___EmotionJSX(EuiPopover, {
    button: ___EmotionJSX(EuiButtonEmpty, _extends({
      onClick: function onClick() {
        return setIsPopoverOpen(function (isOpen) {
          return !isOpen;
        });
      },
      className: classes,
      size: size,
      color: color,
      iconType: "timeRefresh",
      title: isPaused ? autoRefeshLabelOff : autoRefeshLabelOn,
      isDisabled: isDisabled
    }, rest), usePrettyInterval(Boolean(isPaused), refreshInterval, {
      shortHand: shortHand,
      unit: intervalUnits
    })),
    isOpen: isPopoverOpen,
    closePopover: function closePopover() {
      setIsPopoverOpen(false);
    },
    popoverScreenReaderText: isPaused ? autoRefeshLabelOff : autoRefeshLabelOn
  }, ___EmotionJSX(EuiRefreshInterval, {
    onRefreshChange: onRefreshChange,
    isPaused: isPaused,
    refreshInterval: refreshInterval,
    minInterval: minInterval,
    intervalUnits: intervalUnits
  }));
};
EuiAutoRefreshButton.propTypes = {
  isPaused: PropTypes.bool,
  refreshInterval: PropTypes.number,
  minInterval: PropTypes.number,
  intervalUnits: PropTypes.any,
  onRefreshChange: PropTypes.func.isRequired,
  /**
     * `disabled` is also allowed
     */
  isDisabled: PropTypes.bool,
  /**
     * Reduces the time unit to a single letter
     */
  shortHand: PropTypes.bool,
  /**
     * Any of the named color palette options.
     */
  color: PropTypes.any,
  size: PropTypes.any,
  /**
     * Ensure the text of the button sits flush to the left, right, or both sides of its container
     */
  flush: PropTypes.any,
  /**
     * Force disables the button and changes the icon to a loading spinner
     */
  isLoading: PropTypes.bool,
  href: PropTypes.string,
  target: PropTypes.string,
  rel: PropTypes.string,
  buttonRef: PropTypes.any,
  /**
     * Object of props passed to the `<span>` wrapping the button's content
     */
  contentProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }),
  /**
     * Object of props passed to the `<span>` wrapping the content's text/children only (not icon)
     *
     * This span wrapper can be removed by passing `textProps={false}`.
     */
  textProps: PropTypes.oneOfType([PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any,
    ref: PropTypes.any,
    "data-text": PropTypes.string
  }).isRequired, PropTypes.oneOf([false])]),
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any
};