function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import PropTypes from "prop-types";
import { htmlIdGenerator } from '../../../services';
import { EuiI18n } from '../../i18n';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
import { EuiSelect, EuiFieldNumber, EuiFormLabel, EuiSwitch } from '../../form';
import { EuiScreenReaderOnly } from '../../accessibility';
import { RenderI18nTimeOptions } from '../super_date_picker/time_options';
import { EuiQuickSelectPanel } from '../super_date_picker/quick_select_popover/quick_select_panel';
import { jsx as ___EmotionJSX } from "@emotion/react";
var MILLISECONDS_IN_SECOND = 1000;
var MILLISECONDS_IN_MINUTE = MILLISECONDS_IN_SECOND * 60;
var MILLISECONDS_IN_HOUR = MILLISECONDS_IN_MINUTE * 60;
var fromMilliseconds = function fromMilliseconds(milliseconds, unit) {
  var round = function round(value) {
    return parseFloat(value.toFixed(2));
  };
  if (unit === 'h' || !unit && milliseconds > MILLISECONDS_IN_HOUR) {
    return {
      units: 'h',
      value: round(milliseconds / MILLISECONDS_IN_HOUR)
    };
  }
  if (unit === 'm' || !unit && milliseconds > MILLISECONDS_IN_MINUTE) {
    return {
      units: 'm',
      value: round(milliseconds / MILLISECONDS_IN_MINUTE)
    };
  }
  return {
    units: 's',
    value: round(milliseconds / MILLISECONDS_IN_SECOND)
  };
};
var toMilliseconds = function toMilliseconds(units, value) {
  switch (units) {
    case 'h':
      return Math.round(value * MILLISECONDS_IN_HOUR);
    case 'm':
      return Math.round(value * MILLISECONDS_IN_MINUTE);
    case 's':
    default:
      return Math.round(value * MILLISECONDS_IN_SECOND);
  }
};
var getMinInterval = function getMinInterval(minInterval, unit) {
  if (!minInterval) return 0;
  var _fromMilliseconds = fromMilliseconds(minInterval, unit),
    value = _fromMilliseconds.value;
  return Math.floor(value || 0);
};
export var EuiRefreshInterval = /*#__PURE__*/function (_Component) {
  function EuiRefreshInterval() {
    var _this;
    _classCallCheck(this, EuiRefreshInterval);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiRefreshInterval, [].concat(args));
    _defineProperty(_this, "state", _objectSpread(_objectSpread({}, fromMilliseconds(_this.props.refreshInterval || 0, _this.props.intervalUnits)), {}, {
      min: getMinInterval(_this.props.minInterval, _this.props.intervalUnits)
    }));
    _defineProperty(_this, "generateId", htmlIdGenerator());
    _defineProperty(_this, "refreshSelectionId", _this.generateId());
    _defineProperty(_this, "onValueChange", function (event) {
      var sanitizedValue = parseFloat(event.target.value);
      _this.setState({
        value: isNaN(sanitizedValue) ? '' : sanitizedValue
      }, _this.applyRefreshInterval);
    });
    _defineProperty(_this, "onUnitsChange", function (event) {
      var units = event.target.value;
      _this.setState({
        units: units,
        min: getMinInterval(_this.props.minInterval, units)
      }, _this.applyRefreshInterval);
    });
    _defineProperty(_this, "startRefresh", function () {
      var onRefreshChange = _this.props.onRefreshChange;
      var _this$state = _this.state,
        value = _this$state.value,
        units = _this$state.units;
      if (value !== '' && value > 0 && onRefreshChange !== undefined) {
        onRefreshChange({
          refreshInterval: toMilliseconds(units, value),
          intervalUnits: units,
          isPaused: false
        });
      }
    });
    _defineProperty(_this, "handleKeyDown", function (_ref) {
      var key = _ref.key;
      if (key === 'Enter') {
        _this.startRefresh();
      }
    });
    _defineProperty(_this, "applyRefreshInterval", function () {
      var _this$props = _this.props,
        onRefreshChange = _this$props.onRefreshChange,
        isPaused = _this$props.isPaused,
        minInterval = _this$props.minInterval;
      var _this$state2 = _this.state,
        units = _this$state2.units,
        value = _this$state2.value;
      if (value === '') {
        return;
      }
      if (!onRefreshChange) {
        return;
      }
      var refreshInterval = Math.max(toMilliseconds(units, value), minInterval || 0);
      onRefreshChange({
        refreshInterval: refreshInterval,
        intervalUnits: units,
        isPaused: refreshInterval <= 0 ? true : !!isPaused
      });
    });
    _defineProperty(_this, "toggleRefresh", function () {
      var _this$props2 = _this.props,
        onRefreshChange = _this$props2.onRefreshChange,
        isPaused = _this$props2.isPaused;
      var _this$state3 = _this.state,
        units = _this$state3.units,
        value = _this$state3.value;
      if (!onRefreshChange || value === '') {
        return;
      }
      onRefreshChange({
        refreshInterval: toMilliseconds(units, value),
        intervalUnits: units,
        isPaused: !isPaused
      });
    });
    _defineProperty(_this, "renderScreenReaderText", function (refreshUnitsOptions) {
      var isPaused = _this.props.isPaused;
      var _this$state4 = _this.state,
        value = _this$state4.value,
        units = _this$state4.units;
      var options = refreshUnitsOptions.find(function (_ref2) {
        var value = _ref2.value;
        return value === units;
      });
      var optionText = options ? options.text : '';
      var fullDescription = isPaused ? ___EmotionJSX(EuiI18n, {
        token: "euiRefreshInterval.fullDescriptionOff",
        default: "Refresh is off, interval set to {optionValue} {optionText}.",
        values: {
          optionValue: value,
          optionText: optionText
        }
      }) : ___EmotionJSX(EuiI18n, {
        token: "euiRefreshInterval.fullDescriptionOn",
        default: "Refresh is on, interval set to {optionValue} {optionText}.",
        values: {
          optionValue: value,
          optionText: optionText
        }
      });
      return ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("p", {
        id: _this.refreshSelectionId
      }, fullDescription));
    });
    return _this;
  }
  _inherits(EuiRefreshInterval, _Component);
  return _createClass(EuiRefreshInterval, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var isPaused = this.props.isPaused;
      var _this$state5 = this.state,
        value = _this$state5.value,
        units = _this$state5.units,
        min = _this$state5.min;
      return ___EmotionJSX(EuiI18n, {
        tokens: ['euiRefreshInterval.toggleLabel', 'euiRefreshInterval.toggleAriaLabel', 'euiRefreshInterval.valueAriaLabel', 'euiRefreshInterval.unitsAriaLabel'],
        defaults: ['Refresh every', 'Toggle refresh', 'Refresh interval value', 'Refresh interval units']
      }, function (_ref3) {
        var _ref4 = _slicedToArray(_ref3, 4),
          toggleLabel = _ref4[0],
          toggleAriaLabel = _ref4[1],
          valueAriaLabel = _ref4[2],
          unitsAriaLabel = _ref4[3];
        return ___EmotionJSX(RenderI18nTimeOptions, null, function (_ref5) {
          var refreshUnitsOptions = _ref5.refreshUnitsOptions;
          return ___EmotionJSX(EuiQuickSelectPanel, null, ___EmotionJSX(EuiFlexGroup, {
            alignItems: "center",
            gutterSize: "s",
            responsive: false,
            wrap: true
          }, ___EmotionJSX(EuiFlexItem, {
            grow: false
          }, ___EmotionJSX(EuiSwitch, {
            "data-test-subj": "superDatePickerToggleRefreshButton",
            checked: !isPaused,
            onChange: _this2.toggleRefresh,
            compressed: true
            // The IDs attached to this visible label are unused - we override with our own aria-label
            ,
            label: ___EmotionJSX(EuiFormLabel, null, toggleLabel),
            "aria-label": toggleAriaLabel,
            "aria-labelledby": undefined,
            "aria-describedby": _this2.refreshSelectionId
          })), ___EmotionJSX(EuiFlexItem, {
            style: {
              minWidth: 60
            }
          }, ___EmotionJSX(EuiFieldNumber, {
            compressed: true,
            fullWidth: true,
            value: value,
            min: min,
            onChange: _this2.onValueChange,
            onKeyDown: _this2.handleKeyDown,
            isInvalid: !isPaused && (value === '' || value <= 0),
            disabled: isPaused,
            "aria-label": valueAriaLabel,
            "aria-describedby": _this2.refreshSelectionId,
            "data-test-subj": "superDatePickerRefreshIntervalInput"
          })), ___EmotionJSX(EuiFlexItem, {
            style: {
              minWidth: 100
            },
            grow: 2
          }, ___EmotionJSX(EuiSelect, {
            compressed: true,
            fullWidth: true,
            "aria-label": unitsAriaLabel,
            "aria-describedby": _this2.refreshSelectionId,
            value: units,
            disabled: isPaused,
            options: refreshUnitsOptions,
            onChange: _this2.onUnitsChange,
            onKeyDown: _this2.handleKeyDown,
            "data-test-subj": "superDatePickerRefreshIntervalUnitsSelect"
          }))), _this2.renderScreenReaderText(refreshUnitsOptions));
        });
      });
    }
  }]);
}(Component);
_defineProperty(EuiRefreshInterval, "defaultProps", {
  isPaused: true,
  refreshInterval: 1000,
  minInterval: 0
});
EuiRefreshInterval.propTypes = {
  /**
     * Is refresh paused or running.
     */
  isPaused: PropTypes.bool,
  /**
     * Refresh interval in milliseconds.
     */
  refreshInterval: PropTypes.number,
  /**
     * Allows specifying a minimum interval in milliseconds
     */
  minInterval: PropTypes.number,
  /**
     * By default, refresh interval units will be rounded up to next largest unit of time
     * (for example, 90 seconds will become 2m).
     *
     * If you do not want this behavior, you can manually control the rendered unit via this prop.
     */
  intervalUnits: PropTypes.any,
  /**
     * Passes back the updated state of `isPaused`, `refreshInterval`, and `intervalUnits`.
     */
  onRefreshChange: PropTypes.func.isRequired
};