function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import moment from 'moment';
import { EuiDatePicker } from './date_picker';
import { EuiFormRow } from '../form';
import { jsx as ___EmotionJSX } from "@emotion/react";
var DatePicker = function DatePicker() {
  var _useState = useState(moment()),
    _useState2 = _slicedToArray(_useState, 2),
    startDate = _useState2[0],
    setStartDate = _useState2[1];
  var handleChange = function handleChange(date) {
    setStartDate(date);
  };
  return ___EmotionJSX(EuiFormRow, {
    label: "Select a date"
  }, ___EmotionJSX(EuiDatePicker, {
    selected: startDate,
    onChange: handleChange
  }));
};
beforeEach(function () {
  cy.realMount(___EmotionJSX(DatePicker, null));
  cy.get('input.euiDatePicker').should('exist');
});
describe('EuiDatePicker', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations when the calendar widget is expanded', function () {
      cy.get('input.euiDatePicker').realClick();
      cy.get('div.react-datepicker').should('exist');
      cy.checkAxe();
    });
    it('has zero violations after picking a date with arrow keys', function () {
      cy.realPress('Tab');
      cy.get('div.react-datepicker').should('exist');
      cy.repeatRealPress('ArrowDown');
      cy.realPress('ArrowRight');
      cy.realPress('Enter');
      cy.get('div.react-datepicker').should('not.exist');
      cy.checkAxe();
    });
    it('has zero violations after picking a date with dropdown menus', function () {
      cy.realPress('Tab');
      cy.get('div.react-datepicker').should('exist');
      cy.repeatRealPress('Tab', 4);
      cy.get('div.react-datepicker__month-read-view').should('have.focus');
      cy.realPress('Space');
      cy.repeatRealPress('ArrowDown');
      cy.realPress('Enter');
      cy.realPress('Tab');
      cy.realPress('Space');
      cy.repeatRealPress('ArrowDown');
      cy.realPress('Enter');
      cy.checkAxe();
    });
  });
});