var _excluded = ["position", "isDisabled", "isInvalid", "needsUpdating", "value", "buttonProps", "canRoundRelativeUnits", "roundUp", "onChange", "locale", "dateFormat", "utcOffset", "minDate", "maxDate", "timeFormat", "isOpen", "onPopoverToggle", "onPopoverClose", "compressed", "timeOptions"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
// eslint-disable-line import/named

import { useEuiMemoizedStyles } from '../../../../services';
import { useEuiI18n } from '../../../i18n';
import { EuiPopover } from '../../../popover';
import { useFormatTimeString } from '../pretty_duration';
import { EuiDatePopoverContent } from './date_popover_content';
import { euiDatePopoverButtonStyles } from './date_popover_button.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiDatePopoverButton = function EuiDatePopoverButton(props) {
  var position = props.position,
    isDisabled = props.isDisabled,
    isInvalid = props.isInvalid,
    needsUpdating = props.needsUpdating,
    value = props.value,
    buttonProps = props.buttonProps,
    canRoundRelativeUnits = props.canRoundRelativeUnits,
    roundUp = props.roundUp,
    onChange = props.onChange,
    locale = props.locale,
    dateFormat = props.dateFormat,
    utcOffset = props.utcOffset,
    minDate = props.minDate,
    maxDate = props.maxDate,
    timeFormat = props.timeFormat,
    isOpen = props.isOpen,
    onPopoverToggle = props.onPopoverToggle,
    onPopoverClose = props.onPopoverClose,
    compressed = props.compressed,
    timeOptions = props.timeOptions,
    rest = _objectWithoutProperties(props, _excluded);
  var classes = classNames(['euiDatePopoverButton', "euiDatePopoverButton--".concat(position), {
    'euiDatePopoverButton--compressed': compressed,
    'euiDatePopoverButton-isSelected': isOpen,
    'euiDatePopoverButton-isInvalid': isInvalid,
    'euiDatePopoverButton-needsUpdating': needsUpdating,
    'euiDatePopoverButton-disabled': isDisabled
  }]);
  var styles = useEuiMemoizedStyles(euiDatePopoverButtonStyles);
  var cssStyles = [styles.euiDatePopoverButton, buttonProps === null || buttonProps === void 0 ? void 0 : buttonProps.css];
  var formattedValue = useFormatTimeString(value, dateFormat, {
    roundUp: roundUp,
    locale: locale,
    canRoundRelativeUnits: canRoundRelativeUnits
  });
  var title = formattedValue;
  var invalidTitle = useEuiI18n('euiDatePopoverButton.invalidTitle', 'Invalid date: {title}', {
    title: title
  });
  var outdatedTitle = useEuiI18n('euiDatePopoverButton.outdatedTitle', 'Update needed: {title}', {
    title: title
  });
  if (isInvalid) {
    title = invalidTitle;
  } else if (needsUpdating) {
    title = outdatedTitle;
  }
  var button = ___EmotionJSX("button", _extends({
    type: "button",
    onClick: onPopoverToggle,
    className: classes,
    title: title,
    disabled: isDisabled,
    "data-test-subj": "superDatePicker".concat(position, "DatePopoverButton")
  }, buttonProps, {
    css: cssStyles
  }), formattedValue);
  return ___EmotionJSX(EuiPopover, _extends({
    button: button,
    isOpen: isOpen,
    closePopover: onPopoverClose,
    anchorPosition: position === 'start' ? 'downLeft' : 'downRight',
    display: "block",
    panelPaddingSize: "none"
  }, rest, {
    css: value === 'now' && styles.now
  }), ___EmotionJSX(EuiDatePopoverContent, {
    value: value,
    roundUp: roundUp,
    canRoundRelativeUnits: canRoundRelativeUnits,
    onChange: onChange,
    dateFormat: dateFormat,
    timeFormat: timeFormat,
    locale: locale,
    position: position,
    utcOffset: utcOffset,
    timeOptions: timeOptions,
    minDate: minDate,
    maxDate: maxDate
  }));
};
EuiDatePopoverButton.propTypes = {
  className: PropTypes.string,
  buttonProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }),
  dateFormat: PropTypes.string.isRequired,
  isDisabled: PropTypes.bool,
  isInvalid: PropTypes.bool,
  isOpen: PropTypes.bool.isRequired,
  needsUpdating: PropTypes.bool,
  locale: PropTypes.any,
  onChange: PropTypes.func.isRequired,
  onPopoverClose: PropTypes.any.isRequired,
  onPopoverToggle: PropTypes.func.isRequired,
  position: PropTypes.oneOf(["start", "end"]).isRequired,
  canRoundRelativeUnits: PropTypes.bool,
  roundUp: PropTypes.bool,
  timeFormat: PropTypes.string.isRequired,
  value: PropTypes.string.isRequired,
  utcOffset: PropTypes.number,
  minDate: PropTypes.any,
  maxDate: PropTypes.any,
  compressed: PropTypes.bool,
  timeOptions: PropTypes.shape({
    timeTenseOptions: PropTypes.arrayOf(PropTypes.any.isRequired).isRequired,
    timeUnitsOptions: PropTypes.arrayOf(PropTypes.any.isRequired).isRequired,
    relativeOptions: PropTypes.arrayOf(PropTypes.shape({
      text: PropTypes.string.isRequired,
      value: PropTypes.oneOfType([PropTypes.oneOf(["s", "m", "h", "d", "w", "M", "y"]).isRequired, PropTypes.oneOf(["s+", "m+", "h+", "d+", "w+", "M+", "y+"]).isRequired]).isRequired
    }).isRequired).isRequired,
    relativeRoundingLabels: PropTypes.any.isRequired,
    refreshUnitsOptions: PropTypes.arrayOf(PropTypes.any.isRequired).isRequired,
    commonDurationRanges: PropTypes.arrayOf(PropTypes.shape({
      end: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired,
      label: PropTypes.string,
      start: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired
    }).isRequired).isRequired
  }).isRequired
};
EuiDatePopoverButton.displayName = 'EuiDatePopoverButton';