/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiMaxBreakpoint, logicalCSS } from '../../../../global_styling';
import { euiFormVariables } from '../../../form/form.styles';
export var euiDatePopoverContentStyles = function euiDatePopoverContentStyles(euiThemeContext) {
  var _euiFormVariables = euiFormVariables(euiThemeContext),
    maxWidth = _euiFormVariables.maxWidth;
  return {
    euiDatePopoverContent: /*#__PURE__*/css("&,& .react-datepicker{", logicalCSS('width', maxWidth), " ", logicalCSS('max-width', '100%'), " ", euiMaxBreakpoint(euiThemeContext, 's'), "{", logicalCSS('width', '284px'), ";}};label:euiDatePopoverContent;")
  };
};