function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import PropTypes from "prop-types";
import moment from 'moment';
import dateMath from '@elastic/datemath';
import { htmlIdGenerator } from '../../../../services';
import { EuiI18n } from '../../../i18n';
import { EuiScreenReaderOnly } from '../../../accessibility';
import { EuiButton, EuiButtonIcon } from '../../../button';
import { EuiFlexGroup, EuiFlexItem } from '../../../flex';
import { EuiSelect, EuiFieldNumber } from '../../../form';
import { EuiToolTip } from '../../../tool_tip';
import { NEXT } from '../time_options';
import { parseTimeParts } from './quick_select_utils';
import { EuiQuickSelectPanel } from './quick_select_panel';
import { jsx as ___EmotionJSX } from "@emotion/react";
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "1bcvmj9-render",
  styles: "> div{position:relative;overflow:visible;};label:render;"
} : {
  name: "1bcvmj9-render",
  styles: "> div{position:relative;overflow:visible;};label:render;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref4 = process.env.NODE_ENV === "production" ? {
  name: "12n8nux-render",
  styles: "position:absolute;right:0;bottom:100%;transform:translateY(-33%);label:render;"
} : {
  name: "12n8nux-render",
  styles: "position:absolute;right:0;bottom:100%;transform:translateY(-33%);label:render;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var EuiQuickSelect = /*#__PURE__*/function (_Component) {
  function EuiQuickSelect(props) {
    var _this;
    _classCallCheck(this, EuiQuickSelect);
    _this = _callSuper(this, EuiQuickSelect, [props]);
    _defineProperty(_this, "generateId", htmlIdGenerator());
    _defineProperty(_this, "timeSelectionId", _this.generateId());
    _defineProperty(_this, "legendId", _this.generateId());
    _defineProperty(_this, "onTimeTenseChange", function (event) {
      _this.setState({
        timeTense: event.target.value
      });
    });
    _defineProperty(_this, "onTimeValueChange", function (event) {
      var sanitizedValue = parseInt(event.target.value, 10);
      _this.setState({
        timeValue: isNaN(sanitizedValue) ? 0 : sanitizedValue
      });
    });
    _defineProperty(_this, "onTimeUnitsChange", function (event) {
      _this.setState({
        timeUnits: event.target.value
      });
    });
    _defineProperty(_this, "handleKeyDown", function (_ref) {
      var key = _ref.key;
      if (key === 'Enter') {
        _this.applyQuickSelect();
      }
    });
    _defineProperty(_this, "applyQuickSelect", function () {
      var _this$state = _this.state,
        timeTense = _this$state.timeTense,
        timeValue = _this$state.timeValue,
        timeUnits = _this$state.timeUnits;
      if (timeTense === NEXT) {
        _this.props.applyTime({
          start: 'now',
          end: "now+".concat(timeValue).concat(timeUnits),
          quickSelect: _objectSpread({}, _this.state)
        });
        return;
      }
      _this.props.applyTime({
        start: "now-".concat(timeValue).concat(timeUnits),
        end: 'now',
        quickSelect: _objectSpread({}, _this.state)
      });
    });
    _defineProperty(_this, "getBounds", function () {
      var startMoment = dateMath.parse(_this.props.start);
      var endMoment = dateMath.parse(_this.props.end, {
        roundUp: true
      });
      return {
        min: startMoment && startMoment.isValid() ? startMoment : moment().subtract(15, 'minute'),
        max: endMoment && endMoment.isValid() ? endMoment : moment()
      };
    });
    _defineProperty(_this, "stepForward", function () {
      var _this$getBounds = _this.getBounds(),
        min = _this$getBounds.min,
        max = _this$getBounds.max;
      var diff = max.diff(min);
      _this.props.applyTime({
        start: moment(max).add(1, 'ms').toISOString(),
        end: moment(max).add(diff + 1, 'ms').toISOString(),
        keepPopoverOpen: true
      });
    });
    _defineProperty(_this, "stepBackward", function () {
      var _this$getBounds2 = _this.getBounds(),
        min = _this$getBounds2.min,
        max = _this$getBounds2.max;
      var diff = max.diff(min);
      _this.props.applyTime({
        start: moment(min).subtract(diff + 1, 'ms').toISOString(),
        end: moment(min).subtract(1, 'ms').toISOString(),
        keepPopoverOpen: true
      });
    });
    var _parseTimeParts = parseTimeParts(props.start, props.end),
      timeTenseDefault = _parseTimeParts.timeTense,
      timeUnitsDefault = _parseTimeParts.timeUnits,
      timeValueDefault = _parseTimeParts.timeValue;
    _this.state = {
      timeTense: props.prevQuickSelect && props.prevQuickSelect.timeTense ? props.prevQuickSelect.timeTense : timeTenseDefault,
      timeValue: props.prevQuickSelect && props.prevQuickSelect.timeValue ? props.prevQuickSelect.timeValue : timeValueDefault,
      timeUnits: props.prevQuickSelect && props.prevQuickSelect.timeUnits ? props.prevQuickSelect.timeUnits : timeUnitsDefault
    };
    return _this;
  }
  _inherits(EuiQuickSelect, _Component);
  return _createClass(EuiQuickSelect, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$state2 = this.state,
        timeTense = _this$state2.timeTense,
        timeValue = _this$state2.timeValue,
        timeUnits = _this$state2.timeUnits;
      var _this$props$timeOptio = this.props.timeOptions,
        timeTenseOptions = _this$props$timeOptio.timeTenseOptions,
        timeUnitsOptions = _this$props$timeOptio.timeUnitsOptions;
      var matchedTimeUnit = timeUnitsOptions.find(function (_ref2) {
        var value = _ref2.value;
        return value === timeUnits;
      });
      var timeUnit = matchedTimeUnit ? matchedTimeUnit.text : '';
      return ___EmotionJSX(EuiQuickSelectPanel, {
        component: "fieldset",
        title: ___EmotionJSX(EuiI18n, {
          token: "euiQuickSelect.quickSelectTitle",
          default: "Quick select"
        }),
        titleId: this.legendId,
        "aria-describedby": this.timeSelectionId,
        css: _ref3
      }, ___EmotionJSX(EuiFlexGroup, {
        css: _ref4,
        alignItems: "center",
        gutterSize: "s",
        responsive: false
      }, ___EmotionJSX(EuiFlexItem, {
        grow: false
      }, ___EmotionJSX(EuiI18n, {
        token: "euiQuickSelect.previousLabel",
        default: "Previous time window"
      }, function (previousLabel) {
        return ___EmotionJSX(EuiToolTip, {
          content: previousLabel
        }, ___EmotionJSX(EuiButtonIcon, {
          "aria-label": previousLabel,
          iconType: "arrowLeft",
          onClick: _this2.stepBackward
        }));
      })), ___EmotionJSX(EuiFlexItem, {
        grow: false
      }, ___EmotionJSX(EuiI18n, {
        token: "euiQuickSelect.nextLabel",
        default: "Next time window"
      }, function (nextLabel) {
        return ___EmotionJSX(EuiToolTip, {
          content: nextLabel
        }, ___EmotionJSX(EuiButtonIcon, {
          "aria-label": nextLabel,
          iconType: "arrowRight",
          onClick: _this2.stepForward
        }));
      }))), ___EmotionJSX(EuiFlexGroup, {
        gutterSize: "s",
        responsive: false
      }, ___EmotionJSX(EuiFlexItem, null, ___EmotionJSX(EuiI18n, {
        token: "euiQuickSelect.tenseLabel",
        default: "Time tense"
      }, function (tenseLabel) {
        return ___EmotionJSX(EuiSelect, {
          compressed: true,
          onKeyDown: _this2.handleKeyDown,
          "aria-label": tenseLabel,
          "aria-describedby": "".concat(_this2.timeSelectionId, " ").concat(_this2.legendId),
          value: timeTense,
          options: timeTenseOptions,
          onChange: _this2.onTimeTenseChange
        });
      })), ___EmotionJSX(EuiFlexItem, null, ___EmotionJSX(EuiI18n, {
        token: "euiQuickSelect.valueLabel",
        default: "Time value"
      }, function (valueLabel) {
        return ___EmotionJSX(EuiFieldNumber, {
          compressed: true,
          onKeyDown: _this2.handleKeyDown,
          "aria-describedby": "".concat(_this2.timeSelectionId, " ").concat(_this2.legendId),
          "aria-label": valueLabel,
          value: timeValue,
          onChange: _this2.onTimeValueChange
        });
      })), ___EmotionJSX(EuiFlexItem, null, ___EmotionJSX(EuiI18n, {
        token: "euiQuickSelect.unitLabel",
        default: "Time unit"
      }, function (unitLabel) {
        return ___EmotionJSX(EuiSelect, {
          compressed: true,
          onKeyDown: _this2.handleKeyDown,
          "aria-label": unitLabel,
          "aria-describedby": "".concat(_this2.timeSelectionId, " ").concat(_this2.legendId),
          value: timeUnits,
          options: timeUnitsOptions,
          onChange: _this2.onTimeUnitsChange
        });
      })), ___EmotionJSX(EuiFlexItem, {
        grow: false
      }, ___EmotionJSX(EuiButton, {
        "aria-describedby": "".concat(this.timeSelectionId, " ").concat(this.legendId),
        "data-test-subj": "superDatePickerQuickSelectApplyButton",
        minWidth: 0 // Allow the button to shrink
        ,
        size: "s",
        onClick: this.applyQuickSelect,
        disabled: timeValue <= 0
      }, ___EmotionJSX(EuiI18n, {
        token: "euiQuickSelect.applyButton",
        default: "Apply"
      })))), ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("p", {
        id: this.timeSelectionId
      }, ___EmotionJSX(EuiI18n, {
        token: "euiQuickSelect.fullDescription",
        default: "Currently set to {timeTense} {timeValue} {timeUnit}.",
        values: {
          timeTense: timeTense,
          timeValue: timeValue,
          timeUnit: timeUnit
        }
      }))));
    }
  }]);
}(Component);
EuiQuickSelect.propTypes = {
  applyTime: PropTypes.func.isRequired,
  start: PropTypes.string.isRequired,
  end: PropTypes.string.isRequired,
  prevQuickSelect: PropTypes.shape({
    timeTense: PropTypes.string.isRequired,
    timeValue: PropTypes.number.isRequired,
    timeUnits: PropTypes.oneOf(["s", "m", "h", "d", "w", "M", "y"]).isRequired
  }),
  timeOptions: PropTypes.shape({
    timeTenseOptions: PropTypes.arrayOf(PropTypes.any.isRequired).isRequired,
    timeUnitsOptions: PropTypes.arrayOf(PropTypes.any.isRequired).isRequired,
    relativeOptions: PropTypes.arrayOf(PropTypes.shape({
      text: PropTypes.string.isRequired,
      value: PropTypes.oneOfType([PropTypes.oneOf(["s", "m", "h", "d", "w", "M", "y"]).isRequired, PropTypes.oneOf(["s+", "m+", "h+", "d+", "w+", "M+", "y+"]).isRequired]).isRequired
    }).isRequired).isRequired,
    relativeRoundingLabels: PropTypes.any.isRequired,
    refreshUnitsOptions: PropTypes.arrayOf(PropTypes.any.isRequired).isRequired,
    commonDurationRanges: PropTypes.arrayOf(PropTypes.shape({
      end: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired,
      label: PropTypes.string,
      start: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired
    }).isRequired).isRequired
  }).isRequired
};