/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiFontSize, euiScrollBarStyles, logicalCSS, logicalCSSWithFallback, mathWithUnits } from '../../../../global_styling';
export var euiQuickSelectPanelStyles = function euiQuickSelectPanelStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiQuickSelectPanel: /*#__PURE__*/css("&:not(:first-child){", logicalCSS('border-top', euiTheme.border.thin), " ", logicalCSS('padding-top', euiTheme.size.m), " ", logicalCSS('margin-top', euiTheme.size.m), ";};label:euiQuickSelectPanel;"),
    euiQuickSelectPanel__title: /*#__PURE__*/css("float:left;", logicalCSS('margin-bottom', euiTheme.size.m), ";;label:euiQuickSelectPanel__title;"),
    euiQuickSelectPanel__section: /*#__PURE__*/css("clear:both;", logicalCSS('margin-top', euiTheme.size.s), " ", logicalCSS('max-height', mathWithUnits(euiTheme.size.m, function (x) {
      return x * 12;
    })), " overflow:hidden;", logicalCSSWithFallback('overflow-y', 'auto'), " ", euiScrollBarStyles(euiThemeContext), " ", euiFontSize(euiThemeContext, 's'), ";;label:euiQuickSelectPanel__section;")
  };
};