var _excluded = ["applyTime"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState, useCallback, useMemo } from 'react';
import PropTypes from "prop-types";
import { useEuiMemoizedStyles } from '../../../../services';
import { useEuiI18n } from '../../../i18n';
import { EuiButtonEmpty } from '../../../button';
import { EuiIcon } from '../../../icon';
import { EuiPopover } from '../../../popover';
import { euiQuickSelectPopoverStyles } from './quick_select_popover.styles';
import { EuiQuickSelectPanel } from './quick_select_panel';
import { EuiQuickSelect } from './quick_select';
import { EuiCommonlyUsedTimeRanges } from './commonly_used_time_ranges';
import { EuiRecentlyUsed } from './recently_used';
import { EuiRefreshInterval } from '../../auto_refresh/refresh_interval';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiQuickSelectPopover = function EuiQuickSelectPopover(_ref) {
  var _applyTime = _ref.applyTime,
    props = _objectWithoutProperties(_ref, _excluded);
  var _useState = useState(),
    _useState2 = _slicedToArray(_useState, 2),
    prevQuickSelect = _useState2[0],
    setQuickSelect = _useState2[1];
  var _useState3 = useState(false),
    _useState4 = _slicedToArray(_useState3, 2),
    isOpen = _useState4[0],
    setIsOpen = _useState4[1];
  var closePopover = useCallback(function () {
    return setIsOpen(false);
  }, []);
  var togglePopover = useCallback(function () {
    return setIsOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var applyTime = useCallback(function (_ref2) {
    var start = _ref2.start,
      end = _ref2.end,
      quickSelect = _ref2.quickSelect,
      _ref2$keepPopoverOpen = _ref2.keepPopoverOpen,
      keepPopoverOpen = _ref2$keepPopoverOpen === void 0 ? false : _ref2$keepPopoverOpen;
    _applyTime({
      start: start,
      end: end
    });
    if (quickSelect) {
      setQuickSelect(quickSelect);
    }
    if (!keepPopoverOpen) {
      closePopover();
    }
  }, [_applyTime, closePopover]);
  var buttonlabel = useEuiI18n('euiQuickSelectPopover.buttonLabel', 'Date quick select');
  var styles = useEuiMemoizedStyles(euiQuickSelectPopoverStyles);
  var quickSelectButton = ___EmotionJSX(EuiButtonEmpty, {
    css: styles.euiQuickSelectPopoverButton,
    contentProps: {
      css: styles.euiQuickSelectPopoverButton__content
    },
    onClick: togglePopover,
    "aria-label": buttonlabel,
    title: buttonlabel,
    size: "xs",
    iconType: "arrowDown",
    iconSide: "right",
    isDisabled: props.isDisabled,
    "data-test-subj": "superDatePickerToggleQuickMenuButton"
  }, ___EmotionJSX(EuiIcon, {
    type: "calendar"
  }));
  return ___EmotionJSX(EuiPopover, {
    button: quickSelectButton,
    isOpen: isOpen,
    closePopover: closePopover,
    anchorPosition: "downLeft"
  }, ___EmotionJSX(EuiQuickSelectPanels, _extends({}, props, {
    applyTime: applyTime,
    prevQuickSelect: prevQuickSelect
  })));
};
EuiQuickSelectPopover.propTypes = {
  applyRefreshInterval: PropTypes.func,
  applyTime: PropTypes.func.isRequired,
  commonlyUsedRanges: PropTypes.arrayOf(PropTypes.shape({
    end: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired,
    label: PropTypes.string,
    start: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired
  }).isRequired).isRequired,
  customQuickSelectPanels: PropTypes.arrayOf(PropTypes.shape({
    title: PropTypes.string.isRequired,
    content: PropTypes.element.isRequired
  }).isRequired),
  customQuickSelectRender: PropTypes.func,
  dateFormat: PropTypes.string.isRequired,
  end: PropTypes.string.isRequired,
  isDisabled: PropTypes.bool.isRequired,
  isPaused: PropTypes.bool.isRequired,
  recentlyUsedRanges: PropTypes.arrayOf(PropTypes.shape({
    end: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired,
    label: PropTypes.string,
    start: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired
  }).isRequired).isRequired,
  refreshInterval: PropTypes.number.isRequired,
  refreshMinInterval: PropTypes.number,
  intervalUnits: PropTypes.any,
  start: PropTypes.string.isRequired,
  timeOptions: PropTypes.shape({
    timeTenseOptions: PropTypes.arrayOf(PropTypes.any.isRequired).isRequired,
    timeUnitsOptions: PropTypes.arrayOf(PropTypes.any.isRequired).isRequired,
    relativeOptions: PropTypes.arrayOf(PropTypes.shape({
      text: PropTypes.string.isRequired,
      value: PropTypes.oneOfType([PropTypes.oneOf(["s", "m", "h", "d", "w", "M", "y"]).isRequired, PropTypes.oneOf(["s+", "m+", "h+", "d+", "w+", "M+", "y+"]).isRequired]).isRequired
    }).isRequired).isRequired,
    relativeRoundingLabels: PropTypes.any.isRequired,
    refreshUnitsOptions: PropTypes.arrayOf(PropTypes.any.isRequired).isRequired,
    commonDurationRanges: PropTypes.arrayOf(PropTypes.shape({
      end: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired,
      label: PropTypes.string,
      start: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired
    }).isRequired).isRequired
  }).isRequired
};
export var EuiQuickSelectPanels = function EuiQuickSelectPanels(_ref3) {
  var start = _ref3.start,
    end = _ref3.end,
    dateFormat = _ref3.dateFormat,
    timeOptions = _ref3.timeOptions,
    commonlyUsedRanges = _ref3.commonlyUsedRanges,
    recentlyUsedRanges = _ref3.recentlyUsedRanges,
    customQuickSelectPanels = _ref3.customQuickSelectPanels,
    customQuickSelectRender = _ref3.customQuickSelectRender,
    isPaused = _ref3.isPaused,
    refreshInterval = _ref3.refreshInterval,
    refreshMinInterval = _ref3.refreshMinInterval,
    intervalUnits = _ref3.intervalUnits,
    applyRefreshInterval = _ref3.applyRefreshInterval,
    applyTime = _ref3.applyTime,
    prevQuickSelect = _ref3.prevQuickSelect;
  var styles = useEuiMemoizedStyles(euiQuickSelectPopoverStyles);
  var quickSelectElement = ___EmotionJSX(EuiQuickSelect, {
    applyTime: applyTime,
    start: start,
    end: end,
    prevQuickSelect: prevQuickSelect,
    timeOptions: timeOptions
  });
  var commonlyUsedElement = ___EmotionJSX(EuiCommonlyUsedTimeRanges, {
    applyTime: applyTime,
    commonlyUsedRanges: commonlyUsedRanges
  });
  var recentlyUsedElement = ___EmotionJSX(EuiRecentlyUsed, {
    applyTime: applyTime,
    commonlyUsedRanges: commonlyUsedRanges,
    dateFormat: dateFormat,
    recentlyUsedRanges: recentlyUsedRanges
  });
  var refreshIntervalElement = applyRefreshInterval && ___EmotionJSX(EuiRefreshInterval, {
    onRefreshChange: applyRefreshInterval,
    isPaused: isPaused,
    refreshInterval: refreshInterval,
    minInterval: refreshMinInterval,
    intervalUnits: intervalUnits
  });
  var customQuickSelectPanelsElement = useMemo(function () {
    if (!customQuickSelectPanels) {
      return null;
    }
    return customQuickSelectPanels.map(function (_ref4) {
      var title = _ref4.title,
        content = _ref4.content;
      return ___EmotionJSX(EuiQuickSelectPanel, {
        key: title,
        title: title
      }, /*#__PURE__*/React.cloneElement(content, {
        applyTime: applyTime
      }));
    });
  }, [customQuickSelectPanels, applyTime]);
  return ___EmotionJSX("div", {
    css: styles.euiQuickSelectPopover,
    className: "euiQuickSelectPopover",
    "data-test-subj": "superDatePickerQuickMenu"
  }, customQuickSelectRender ? customQuickSelectRender({
    quickSelect: quickSelectElement,
    commonlyUsedRanges: commonlyUsedElement,
    recentlyUsedRanges: recentlyUsedElement,
    refreshInterval: refreshIntervalElement,
    customQuickSelectPanels: customQuickSelectPanelsElement
  }) : ___EmotionJSX(React.Fragment, null, quickSelectElement, commonlyUsedElement, recentlyUsedElement, refreshIntervalElement, customQuickSelectPanelsElement));
};
EuiQuickSelectPanels.propTypes = {
  prevQuickSelect: PropTypes.shape({
    timeTense: PropTypes.string.isRequired,
    timeValue: PropTypes.number.isRequired,
    timeUnits: PropTypes.oneOf(["s", "m", "h", "d", "w", "M", "y"]).isRequired
  })
};