/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS } from '../../../../global_styling';
import { euiFormMaxWidth } from '../../../form/form.styles';
export var euiQuickSelectPopoverStyles = function euiQuickSelectPopoverStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var formMaxWidth = euiFormMaxWidth(euiThemeContext);
  return {
    euiQuickSelectPopover: /*#__PURE__*/css(logicalCSS('width', formMaxWidth), " ", logicalCSS('max-width', '100%'), ";;label:euiQuickSelectPopover;"),
    euiQuickSelectPopoverButton: /*#__PURE__*/css(logicalCSS('border-top-right-radius', 0), " ", logicalCSS('border-bottom-right-radius', 0), ".euiIcon{", logicalCSS('width', euiTheme.size.base), ";};label:euiQuickSelectPopoverButton;"),
    euiQuickSelectPopoverButton__content: /*#__PURE__*/css("gap:", euiTheme.size.xs, ";;label:euiQuickSelectPopoverButton__content;")
  };
};