/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import { useGeneratedHtmlId } from '../../../../services';
import { useEuiI18n } from '../../../i18n';
import { EuiFlexGroup, EuiFlexItem } from '../../../flex';
import { EuiLink } from '../../../link';
import { PrettyDuration } from '../pretty_duration';
import { EuiQuickSelectPanel } from './quick_select_panel';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiRecentlyUsed = function EuiRecentlyUsed(_ref) {
  var applyTime = _ref.applyTime,
    commonlyUsedRanges = _ref.commonlyUsedRanges,
    dateFormat = _ref.dateFormat,
    _ref$recentlyUsedRang = _ref.recentlyUsedRanges,
    recentlyUsedRanges = _ref$recentlyUsedRang === void 0 ? [] : _ref$recentlyUsedRang;
  var title = useEuiI18n('euiRecentlyUsed.legend', 'Recently used date ranges');
  var legendId = useGeneratedHtmlId();
  if (recentlyUsedRanges.length === 0) {
    return null;
  }
  var links = recentlyUsedRanges.map(function (_ref2) {
    var start = _ref2.start,
      end = _ref2.end;
    var applyRecentlyUsed = function applyRecentlyUsed() {
      applyTime({
        start: start,
        end: end
      });
    };
    return ___EmotionJSX(EuiFlexItem, {
      component: "li",
      key: "".concat(start, "-").concat(end)
    }, ___EmotionJSX(EuiLink, {
      onClick: applyRecentlyUsed
    }, ___EmotionJSX(PrettyDuration, {
      timeFrom: start,
      timeTo: end,
      quickRanges: commonlyUsedRanges,
      dateFormat: dateFormat
    })));
  });
  return ___EmotionJSX(EuiQuickSelectPanel, {
    component: "fieldset",
    titleId: legendId,
    title: title
  }, ___EmotionJSX(EuiFlexGroup, {
    component: "ul",
    gutterSize: "s",
    direction: "column"
  }, links));
};
EuiRecentlyUsed.propTypes = {
  applyTime: PropTypes.func.isRequired,
  commonlyUsedRanges: PropTypes.arrayOf(PropTypes.shape({
    end: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired,
    label: PropTypes.string,
    start: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired
  }).isRequired).isRequired,
  dateFormat: PropTypes.string.isRequired,
  recentlyUsedRanges: PropTypes.arrayOf(PropTypes.shape({
    end: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired,
    label: PropTypes.string,
    start: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired
  }).isRequired)
};
EuiRecentlyUsed.displayName = 'EuiRecentlyUsed';