function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { tint, shade, makeHighContrastColor } from '../../../services';
import { euiFontSize, euiMaxBreakpoint, logicalCSS, mathWithUnits } from '../../../global_styling';
import { euiFormVariables, euiFormControlDefaultShadow, euiFormControlInvalidStyles, euiFormControlDisabledStyles } from '../../form/form.styles';
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1e4qgxg-euiSuperDatePicker__range",
  styles: "flex-grow:1;overflow:hidden;label:euiSuperDatePicker__range;"
} : {
  name: "1e4qgxg-euiSuperDatePicker__range",
  styles: "flex-grow:1;overflow:hidden;label:euiSuperDatePicker__range;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiSuperDatePickerStyles = function euiSuperDatePickerStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var forms = euiFormVariables(euiThemeContext);
  var inputWidth = euiTheme.base * 30;
  var buttonWidth = euiTheme.base * 7; // @see _button_display.styles.ts
  var gap = euiTheme.size.s;

  // Default restricted width
  var restrictedWidth = mathWithUnits(gap, function (gap) {
    return inputWidth + gap + buttonWidth;
  });

  // Set a sensible min-width for when width is auto
  var minFormWidth = parseFloat(forms.maxWidth) / 2;
  var autoMinWidth = mathWithUnits(gap, function (gap) {
    return minFormWidth + gap + buttonWidth;
  });

  // Needs updating colors
  var needsUpdatingBackgroundColor = colorMode === 'DARK' ? shade(euiTheme.colors.success, 0.7) : tint(euiTheme.colors.success, 0.9);
  var needsUpdatingTextColor = makeHighContrastColor(euiTheme.colors.success)(needsUpdatingBackgroundColor);
  return {
    euiSuperDatePicker: /*#__PURE__*/css("display:flex;gap:", gap, ";", logicalCSS('max-width', '100%'), " ", euiMaxBreakpoint(euiThemeContext, 'm'), "{", logicalCSS('width', '100%'), ";};label:euiSuperDatePicker;"),
    widths: {
      restricted: /*#__PURE__*/css(logicalCSS('width', restrictedWidth), ";;label:restricted;"),
      full: /*#__PURE__*/css(logicalCSS('width', '100%'), ";;label:full;"),
      auto: /*#__PURE__*/css("display:inline-flex;", logicalCSS('min-width', "min(".concat(autoMinWidth, ", 100%)")), " ", logicalCSS('width', 'auto'), ";;label:auto;")
    },
    // Special rendering cases that override all permutations of the above widths
    noUpdateButton: {
      // Skipping css`` and using the `label` key instead to reduce repeat Emotion generated classNames
      restricted: "\n        label: noUpdateButton;\n        ".concat(logicalCSS('width', "".concat(inputWidth, "px")), ";\n      "),
      auto: "\n        label: noUpdateButton;\n        ".concat(logicalCSS('min-width', "min(".concat(minFormWidth, "px, 100%)")), ";\n      "),
      full: "\n        label: noUpdateButton;\n      "
    },
    isAutoRefreshOnly: {
      // display: block over flex is required to have the nested .euiPopover wrap expand to the wrapper width
      restricted: "\n        label: isAutoRefreshOnly;\n        display: block;\n        ".concat(logicalCSS('width', forms.maxWidth), "\n      "),
      auto: "\n        label: isAutoRefreshOnly;\n      ",
      full: "\n        label: isAutoRefreshOnly;\n        display: block;\n      "
    },
    // isQuickSelectOnly forces `width` to be `auto`
    isQuickSelectOnly: /*#__PURE__*/css(logicalCSS('min-width', 0), ".euiFormControlLayout__prepend{", logicalCSS('max-width', 'none'), ";};label:isQuickSelectOnly;"),
    euiSuperDatePicker__range: _ref,
    euiSuperDatePicker__rangeInput: /*#__PURE__*/css("flex-grow:1;", logicalCSS('width', 'auto'), " overflow:hidden;;label:euiSuperDatePicker__rangeInput;"),
    euiSuperDatePicker__prettyFormat: /*#__PURE__*/css(_buttonStyles(euiThemeContext), " text-align:start;;label:euiSuperDatePicker__prettyFormat;"),
    // Form states
    states: {
      euiSuperDatePicker__formControlLayout: /*#__PURE__*/css(".euiFormControlLayout__childrenWrapper{", euiFormControlDefaultShadow(euiThemeContext), " box-shadow:none;};label:euiSuperDatePicker__formControlLayout;"),
      default: /*#__PURE__*/css(".euiFormControlLayout__childrenWrapper{color:", forms.textColor, ";background-color:", forms.backgroundColor, ";}.euiDatePopoverButton{", euiFormControlDefaultShadow(euiThemeContext), " box-shadow:none;}.euiDatePopoverButton:focus,.euiPopover-isOpen .euiDatePopoverButton{--euiFormControlStateColor:", euiTheme.colors.primary, ";background-size:100% 100%;};label:default;"),
      disabled: /*#__PURE__*/css(".euiFormControlLayout__childrenWrapper{", euiFormControlDisabledStyles(euiThemeContext), ";};label:disabled;"),
      invalid: /*#__PURE__*/css(".euiFormControlLayout__childrenWrapper{color:", euiTheme.colors.dangerText, ";background-color:", forms.backgroundColor, ";", euiFormControlInvalidStyles(euiThemeContext), ";};label:invalid;"),
      needsUpdating: /*#__PURE__*/css(".euiFormControlLayout__childrenWrapper{color:", needsUpdatingTextColor, ";background-color:", needsUpdatingBackgroundColor, ";}.euiFormControlLayoutDelimited__delimiter{color:inherit;}.euiDatePopoverButton{", euiFormControlDefaultShadow(euiThemeContext), " background-color:inherit;box-shadow:none;}.euiDatePopoverButton:focus,.euiPopover-isOpen .euiDatePopoverButton{--euiFormControlStateColor:", euiTheme.colors.success, ";background-size:100% 100%;};label:needsUpdating;")
    }
  };
};
export var _buttonStyles = function _buttonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return /*#__PURE__*/css(logicalCSS('height', '100%'), " ", logicalCSS('width', '100%'), " ", logicalCSS('padding-horizontal', euiTheme.size.s), " font-size:", euiFontSize(euiThemeContext, 's').fontSize, ";white-space:nowrap;text-overflow:ellipsis;overflow:hidden;color:inherit;background-color:inherit;&:disabled{cursor:not-allowed;}");
};