var _excluded = ["children", "className", "needsUpdate", "isLoading", "isDisabled", "onClick", "toolTipProps", "showTooltip", "iconOnly", "responsive", "textProps", "fill"];
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { EuiButton } from '../../button';
import { EuiI18n } from '../../i18n';
import { EuiToolTip } from '../../tool_tip';
import { EuiHideFor, EuiShowFor } from '../../responsive';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiSuperUpdateButton = /*#__PURE__*/function (_Component) {
  function EuiSuperUpdateButton() {
    var _this;
    _classCallCheck(this, EuiSuperUpdateButton);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiSuperUpdateButton, [].concat(args));
    _defineProperty(_this, "_isMounted", false);
    _defineProperty(_this, "tooltipTimeout", void 0);
    _defineProperty(_this, "tooltip", null);
    _defineProperty(_this, "setTootipRef", function (node) {
      _this.tooltip = node;
    });
    _defineProperty(_this, "showTooltip", function () {
      if (!_this._isMounted || !_this.tooltip) {
        return;
      }
      _this.tooltip.showToolTip();
    });
    _defineProperty(_this, "hideTooltip", function () {
      if (!_this._isMounted || !_this.tooltip) {
        return;
      }
      _this.tooltip.hideToolTip();
    });
    return _this;
  }
  _inherits(EuiSuperUpdateButton, _Component);
  return _createClass(EuiSuperUpdateButton, [{
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this._isMounted = false;
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this._isMounted = true;
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      var _this2 = this;
      if (this.props.showTooltip && this.props.needsUpdate && !this.props.isDisabled && !this.props.isLoading) {
        this.showTooltip();
        this.tooltipTimeout = setTimeout(function () {
          _this2.hideTooltip();
        }, 2000);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
        children = _this$props.children,
        className = _this$props.className,
        needsUpdate = _this$props.needsUpdate,
        isLoading = _this$props.isLoading,
        isDisabled = _this$props.isDisabled,
        onClick = _this$props.onClick,
        toolTipProps = _this$props.toolTipProps,
        showTooltip = _this$props.showTooltip,
        iconOnly = _this$props.iconOnly,
        _responsive = _this$props.responsive,
        restTextProps = _this$props.textProps,
        fill = _this$props.fill,
        rest = _objectWithoutProperties(_this$props, _excluded);
      // Force responsive for "all" if `iconOnly = true`
      var responsive = iconOnly ? 'all' : _responsive;
      var classes = classNames('euiSuperUpdateButton', className);
      var sharedButtonProps = {
        color: needsUpdate || isLoading ? 'success' : 'primary',
        iconType: needsUpdate || isLoading ? 'kqlFunction' : 'refresh',
        isDisabled: isDisabled,
        onClick: onClick,
        isLoading: isLoading
      };
      var buttonContent = this.renderButtonContent();
      return ___EmotionJSX(EuiToolTip, _extends({
        ref: this.setTootipRef,
        content: this.renderTooltipContent(),
        position: "bottom"
      }, toolTipProps), ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiShowFor, {
        sizes: responsive || 'none'
      }, ___EmotionJSX(EuiButton, _extends({
        className: classes,
        minWidth: false
      }, sharedButtonProps, {
        fill: fill,
        textProps: _objectSpread(_objectSpread({}, restTextProps), {}, {
          className: classNames('euiScreenReaderOnly', restTextProps && restTextProps.className)
        })
      }, rest), buttonContent)), ___EmotionJSX(EuiHideFor, {
        sizes: responsive || 'none'
      }, ___EmotionJSX(EuiButton, _extends({
        className: classes,
        minWidth: 118
      }, sharedButtonProps, {
        fill: fill,
        textProps: restTextProps
      }, rest), buttonContent))));
    }
  }, {
    key: "renderButtonContent",
    value: function renderButtonContent() {
      var _this$props2 = this.props,
        children = _this$props2.children,
        isLoading = _this$props2.isLoading,
        needsUpdate = _this$props2.needsUpdate;
      if (children) {
        return children;
      }
      if (isLoading) {
        return ___EmotionJSX(EuiI18n, {
          token: "euiSuperUpdateButton.updatingButtonLabel",
          default: "Updating"
        });
      }
      if (needsUpdate) {
        return ___EmotionJSX(EuiI18n, {
          token: "euiSuperUpdateButton.updateButtonLabel",
          default: "Update"
        });
      }
      return ___EmotionJSX(EuiI18n, {
        token: "euiSuperUpdateButton.refreshButtonLabel",
        default: "Refresh"
      });
    }
  }, {
    key: "renderTooltipContent",
    value: function renderTooltipContent() {
      if (this.props.isDisabled) {
        return ___EmotionJSX(EuiI18n, {
          token: "euiSuperUpdateButton.cannotUpdateTooltip",
          default: "Cannot update"
        });
      }
      if (this.props.needsUpdate && !this.props.isLoading) {
        return ___EmotionJSX(EuiI18n, {
          token: "euiSuperUpdateButton.clickToApplyTooltip",
          default: "Click to apply"
        });
      }
    }
  }]);
}(Component);
_defineProperty(EuiSuperUpdateButton, "defaultProps", {
  needsUpdate: false,
  isLoading: false,
  isDisabled: false,
  showTooltip: false,
  responsive: ['xs', 's'],
  fill: true
});
EuiSuperUpdateButton.propTypes = {
  isDisabled: PropTypes.bool,
  isLoading: PropTypes.bool,
  needsUpdate: PropTypes.bool,
  onClick: PropTypes.func.isRequired,
  /**
     * Overrides the default button label with a custom React node.
     *
     * When defined, you're responsible for updating the custom label
     * when the data needs updating (the `needsUpdate` prop)
     * or is loading (the `isLoading` prop).
     */
  children: PropTypes.node,
  /**
     * Show the "Click to apply" tooltip
     */
  showTooltip: PropTypes.bool,
  /**
     * Passes props to `EuiToolTip`
     */
  toolTipProps: PropTypes.any,
  /**
     * Returns an IconButton instead
     */
  iconOnly: PropTypes.bool,
  /**
     * Forces state to be `iconOnly` when within provided breakpoints.
     * Remove completely with `false` or provide your own list of breakpoints.
     */
  responsive: PropTypes.oneOfType([PropTypes.oneOf([false]), PropTypes.arrayOf(PropTypes.any.isRequired).isRequired])
};