function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import { EuiDelayHide } from './delay_hide';
import { EuiCheckbox, EuiFieldNumber, EuiFormRow } from '../form';
import { EuiFlexItem } from '../flex';
import { EuiLoadingSpinner } from '../loading';
import { jsx as ___EmotionJSX } from "@emotion/react";
var DelayHide = function DelayHide() {
  var _useState = useState(1000),
    _useState2 = _slicedToArray(_useState, 2),
    minimumDuration = _useState2[0],
    setDuration = _useState2[1];
  var _useState3 = useState(false),
    _useState4 = _slicedToArray(_useState3, 2),
    hide = _useState4[0],
    setHide = _useState4[1];
  return ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiFlexItem, null, ___EmotionJSX(EuiFormRow, null, ___EmotionJSX(EuiCheckbox, {
    id: "dummy-id",
    checked: hide,
    onChange: function onChange(event) {
      return setHide(event.target.checked);
    },
    label: "Hide child"
  })), ___EmotionJSX(EuiFormRow, {
    label: "Minimum duration"
  }, ___EmotionJSX(EuiFieldNumber, {
    value: minimumDuration,
    onChange: function onChange(event) {
      return setDuration(parseInt(event.target.value, 10));
    }
  })), ___EmotionJSX(EuiFormRow, {
    label: "Child to render"
  }, ___EmotionJSX(EuiDelayHide, {
    hide: hide,
    minimumDuration: minimumDuration,
    render: function render() {
      return ___EmotionJSX(EuiLoadingSpinner, {
        size: "m"
      });
    }
  }))));
};
beforeEach(function () {
  cy.realMount(___EmotionJSX(DelayHide, null));
});
describe('EuiHideRender', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations when the hide child input is checked', function () {
      cy.get('input.euiCheckbox__input').realClick();
      cy.get('div.euiFormRow__fieldWrapper').last().find('span[role="progressbar"]', {
        timeout: 5000
      }).should('not.exist');
      cy.checkAxe();
    });
    it('has zero violations when the hide child input is pressed', function () {
      cy.realPress('Tab');
      cy.get('input.euiCheckbox__input').should('have.focus');
      cy.realPress('Space');
      cy.get('div.euiFormRow__fieldWrapper').last().find('span[role="progressbar"]', {
        timeout: 5000
      }).should('not.exist');
      cy.checkAxe();
    });
    it('has zero violations when the hide child input is toggled', function () {
      cy.realPress('Tab');
      cy.get('input.euiCheckbox__input').should('have.focus');
      cy.realPress('Space');
      cy.get('div.euiFormRow__fieldWrapper').last().find('span[role="progressbar"]').should('not.exist');
      cy.realPress('Space');
      cy.get('div.euiFormRow__fieldWrapper').last().find('span[role="progressbar"]', {
        timeout: 5000
      }).should('exist');
      cy.checkAxe();
    });
  });
});