function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["align", "children", "className", "style", "compressed", "descriptionProps", "listItems", "textStyle", "titleProps", "type", "rowGutterSize", "columnGutterSize", "columnWidths"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles, useIsWithinBreakpoints } from '../../services';
import { EuiDescriptionListContext } from './description_list_context';
import { EuiDescriptionListTitle } from './description_list_title';
import { EuiDescriptionListDescription } from './description_list_description';
import { euiDescriptionListStyles } from './description_list.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiDescriptionList = function EuiDescriptionList(_ref) {
  var _ref$align = _ref.align,
    align = _ref$align === void 0 ? 'left' : _ref$align,
    children = _ref.children,
    className = _ref.className,
    style = _ref.style,
    _ref$compressed = _ref.compressed,
    compressed = _ref$compressed === void 0 ? false : _ref$compressed,
    descriptionProps = _ref.descriptionProps,
    listItems = _ref.listItems,
    _ref$textStyle = _ref.textStyle,
    textStyle = _ref$textStyle === void 0 ? 'normal' : _ref$textStyle,
    titleProps = _ref.titleProps,
    _ref$type = _ref.type,
    _type = _ref$type === void 0 ? 'row' : _ref$type,
    _ref$rowGutterSize = _ref.rowGutterSize,
    rowGutterSize = _ref$rowGutterSize === void 0 ? 's' : _ref$rowGutterSize,
    _ref$columnGutterSize = _ref.columnGutterSize,
    columnGutterSize = _ref$columnGutterSize === void 0 ? 's' : _ref$columnGutterSize,
    columnWidths = _ref.columnWidths,
    rest = _objectWithoutProperties(_ref, _excluded);
  var showResponsiveColumns = useIsWithinBreakpoints(['xs', 's']);
  var type = useMemo(function () {
    if (_type === 'responsiveColumn') {
      return showResponsiveColumns ? 'row' : 'column';
    } else {
      return _type;
    }
  }, [_type, showResponsiveColumns]);
  var styles = useEuiMemoizedStyles(euiDescriptionListStyles);
  var cssStyles = [styles.euiDescriptionList, styles[type], styles[align], type === 'column' && styles.rowGap[rowGutterSize], type === 'column' && styles.columnGap[columnGutterSize]];
  var inlineStyles = useMemo(function () {
    if (type === 'column' && columnWidths) {
      // Leave string values as is - e.g. if a consumer passes in a specific '200px' or 'minmax()'
      var convertNumbersToFr = function convertNumbersToFr(value) {
        return typeof value === 'number' ? "".concat(value, "fr") : value;
      };
      var titleWidth = convertNumbersToFr(columnWidths[0]);
      var descriptionWidth = convertNumbersToFr(columnWidths[1]);
      return _objectSpread({
        gridTemplateColumns: "".concat(titleWidth, " ").concat(descriptionWidth)
      }, style);
    }
    return style;
  }, [style, type, columnWidths]);
  var classes = classNames('euiDescriptionList', className);
  var renderedListItems = useMemo(function () {
    if (listItems) {
      return listItems.map(function (item, index) {
        return [___EmotionJSX(EuiDescriptionListTitle, _extends({
          key: "title-".concat(index)
        }, titleProps), item.title), ___EmotionJSX(EuiDescriptionListDescription, _extends({
          key: "description-".concat(index)
        }, descriptionProps), item.description)];
      });
    }
  }, [listItems, descriptionProps, titleProps]);
  return ___EmotionJSX(EuiDescriptionListContext.Provider, {
    value: {
      type: type,
      compressed: compressed,
      textStyle: textStyle,
      align: align,
      rowGutterSize: rowGutterSize
    }
  }, ___EmotionJSX("dl", _extends({
    className: classes,
    css: cssStyles,
    style: inlineStyles
  }, rest, {
    "data-type": _type
  }), listItems ? renderedListItems : children));
};
EuiDescriptionList.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  listItems: PropTypes.arrayOf(PropTypes.shape({
    title: PropTypes.any.isRequired,
    description: PropTypes.any.isRequired
  }).isRequired),
  /**
     * Text alignment
     */
  align: PropTypes.any,
  /**
     * Smaller text and condensed spacing
     */
  compressed: PropTypes.bool,
  /**
     * How should the content be styled, by default
     * this will emphasize the title
     */
  textStyle: PropTypes.oneOf(["normal", "reverse"]),
  /**
     * How each item should be laid out
     */
  type: PropTypes.any,
  /**
     * Props object to be passed to `EuiDescriptionListTitle`
     */
  titleProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }),
  /**
     * Props object to be passed to `EuiDescriptionListDescription`
     */
  descriptionProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }),
  /**
     * Allows customizing the vertical spacing between rows.
     */
  rowGutterSize: PropTypes.any,
  /**
     * Allows customizing the horizontal spacing between columns.
     *
     * Only applies to `column` and `responsiveColumn` types.
     */
  columnGutterSize: PropTypes.any,
  /**
     * Allows customizing specific column widths (e.g. `['100px', '200px']`). The first
     * array value applies to the title column, and the second applies to the description column.
     *
     * Passing numbers instead of CSS width strings will use a ratio of widths.
     * For example, [1, 3] will render a description column 3x the width of the title column.
     * In other words, descriptions will have a width of `75%` and titles will have a width of `25%`.
     *
     * Only applies to `column` and `responsiveColumn` types.
     *
     * _Advanced usage note:_ column width strings also accept [CSS grid special units,
     * sizing, keywords, and sizing functions](https://css-tricks.com/snippets/css/complete-guide-grid/#aa-special-units-functions).
     */
  columnWidths: PropTypes.any
};