function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiFontSize, logicalTextAlignCSS } from '../../global_styling';
import { euiTitle } from '../title/title.styles';
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1yn9gig-inline",
  styles: "display:inline;label:inline;"
} : {
  name: "1yn9gig-inline",
  styles: "display:inline;label:inline;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiDescriptionListDescriptionStyles = function euiDescriptionListDescriptionStyles(euiThemeContext) {
  return {
    euiDescriptionList__description: /*#__PURE__*/css(";label:euiDescriptionList__description;"),
    // Types
    row: /*#__PURE__*/css(";label:row;"),
    column: /*#__PURE__*/css(";label:column;"),
    inline: _ref,
    // This nested block handles just the font styling based on compressed and reverse
    fontStyles: {
      normal: /*#__PURE__*/css(euiFontSize(euiThemeContext, 's'), ";;label:normal;"),
      reverse: /*#__PURE__*/css(euiTitle(euiThemeContext, 'xs'), ";;label:reverse;"),
      compressed: /*#__PURE__*/css(euiTitle(euiThemeContext, 'xxs'), ";;label:compressed;")
    },
    // Nested inline styles for type and font
    inlineStyles: {
      compressed: /*#__PURE__*/css(euiFontSize(euiThemeContext, 'xs'), ";;label:compressed;"),
      normal: /*#__PURE__*/css(euiFontSize(euiThemeContext, 's'), ";;label:normal;")
    },
    // Column types should align description text to the left when EuiDecriptionList is centered
    left: /*#__PURE__*/css(logicalTextAlignCSS('left'), ";;label:left;")
  };
};