function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import { EuiDragDropContext } from './drag_drop_context';
import { euiDragDropReorder } from './services';
import { EuiDraggable } from './draggable';
import { EuiDroppable } from './droppable';
import { EuiPanel } from '../panel';
import { htmlIdGenerator } from '../../services';
import { jsx as ___EmotionJSX } from "@emotion/react";
var makeId = htmlIdGenerator();
var makeList = function makeList(number) {
  var start = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
  return Array.from({
    length: number
  }, function (v, k) {
    return k + start;
  }).map(function (el) {
    return {
      content: "Item ".concat(el),
      id: makeId()
    };
  });
};
var DragAndDrop = function DragAndDrop() {
  var _useState = useState(makeList(3)),
    _useState2 = _slicedToArray(_useState, 2),
    list = _useState2[0],
    setList = _useState2[1];
  var onDragEnd = function onDragEnd(_ref) {
    var source = _ref.source,
      destination = _ref.destination;
    if (source && destination) {
      var items = euiDragDropReorder(list, source.index, destination.index);
      setList(items);
    }
  };
  return ___EmotionJSX(EuiDragDropContext, {
    onDragEnd: onDragEnd
  }, ___EmotionJSX(EuiDroppable, {
    droppableId: "DROPPABLE_AREA",
    spacing: "m",
    withPanel: true
  }, list.map(function (_ref2, idx) {
    var content = _ref2.content,
      id = _ref2.id;
    return ___EmotionJSX(EuiDraggable, {
      spacing: "m",
      key: id,
      index: idx,
      draggableId: id,
      "data-test-subj": "cy-draggable-".concat(idx)
    }, function (provided, state) {
      return ___EmotionJSX(EuiPanel, {
        hasShadow: state.isDragging
      }, content, state.isDragging && ' ✨');
    });
  })));
};
beforeEach(function () {
  cy.realMount(___EmotionJSX(DragAndDrop, null));
});
describe('EuiDragDrop', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on render', function () {
      cy.checkAxe();
    });
    it('has zero violations when an item is in draggable state', function () {
      cy.repeatRealPress('Tab');
      cy.realPress('Space');
      cy.get('div[data-test-subj="cy-draggable-1"]').should('have.focus');
      cy.checkAxe();
    });
    it('has zero violations when an item has been reordered and dropped', function () {
      cy.repeatRealPress('Tab');
      cy.realPress('Space');
      cy.get('div[data-test-subj="cy-draggable-1"]').should('have.focus');
      cy.realPress('ArrowDown');
      cy.realPress('Space');
      cy.get('div[data-test-subj="cy-draggable-2"]').should('have.focus');
      cy.realPress('Space');
      cy.repeatRealPress('ArrowUp');
      cy.realPress('Space');
      cy.get('div[data-test-subj="cy-draggable-0"]').should('have.focus');
      cy.checkAxe();
    });
  });
});