function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["customDragHandle", "draggableId", "isDragDisabled", "hasInteractiveChildren", "isRemovable", "usePortal", "index", "children", "className", "spacing", "style", "data-test-subj"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useContext } from 'react';
import PropTypes from "prop-types";
import { Draggable } from '@hello-pangea/dnd';
import classNames from 'classnames';
import { useEuiMemoizedStyles, cloneElementWithCss } from '../../services';
import { EuiDroppableContext } from './droppable';
import { euiDraggableStyles, euiDraggableItemStyles } from './draggable.styles';
import { EuiPortal } from '../portal';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiDraggable = function EuiDraggable(_ref) {
  var _ref$customDragHandle = _ref.customDragHandle,
    customDragHandle = _ref$customDragHandle === void 0 ? false : _ref$customDragHandle,
    draggableId = _ref.draggableId,
    _ref$isDragDisabled = _ref.isDragDisabled,
    isDragDisabled = _ref$isDragDisabled === void 0 ? false : _ref$isDragDisabled,
    _ref$hasInteractiveCh = _ref.hasInteractiveChildren,
    hasInteractiveChildren = _ref$hasInteractiveCh === void 0 ? false : _ref$hasInteractiveCh,
    _ref$isRemovable = _ref.isRemovable,
    isRemovable = _ref$isRemovable === void 0 ? false : _ref$isRemovable,
    _ref$usePortal = _ref.usePortal,
    usePortal = _ref$usePortal === void 0 ? false : _ref$usePortal,
    index = _ref.index,
    children = _ref.children,
    className = _ref.className,
    _ref$spacing = _ref.spacing,
    spacing = _ref$spacing === void 0 ? 'none' : _ref$spacing,
    style = _ref.style,
    _ref$dataTestSubj = _ref['data-test-subj'],
    dataTestSubj = _ref$dataTestSubj === void 0 ? 'draggable' : _ref$dataTestSubj,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useContext = useContext(EuiDroppableContext),
    cloneItems = _useContext.cloneItems;
  var styles = useEuiMemoizedStyles(euiDraggableStyles);
  var hasCustomDragHandle = customDragHandle !== false;
  return ___EmotionJSX(Draggable, _extends({
    draggableId: draggableId,
    index: index,
    isDragDisabled: isDragDisabled
  }, rest), function (provided, snapshot, rubric) {
    var _provided$dragHandleP, _provided$dragHandleP2;
    var isDragging = snapshot.isDragging;
    var isFullyCustomDragHandle = customDragHandle === 'custom';
    var cssStyles = [styles.euiDraggable, cloneItems && !isDragging && styles.hasClone, isDragging && styles.isDragging, isRemovable && styles.isRemovable, styles.spacing[spacing]];
    var classes = classNames('euiDraggable', className);
    var childClasses = classNames('euiDraggable__item', {
      'euiDraggable__item-isDisabled': isDragDisabled
    });
    var DraggableElement = typeof children === 'function' ? children(provided, snapshot, rubric) : children;
    var content = ___EmotionJSX(React.Fragment, null, ___EmotionJSX("div", _extends({}, provided.draggableProps, !hasCustomDragHandle ? provided.dragHandleProps : {}, {
      ref: provided.innerRef,
      "data-test-subj": dataTestSubj,
      className: classes,
      css: cssStyles,
      style: _objectSpread(_objectSpread({}, style), provided.draggableProps.style)
      // We use [role="group"] instead of [role="button"] when we expect a nested
      // interactive element. Screen readers will cue users that this is a container
      // and has one or more elements inside that are part of a related group.
      ,
      role: isFullyCustomDragHandle ? undefined // prevent wrapper role from removing semantics of the children
      : hasInteractiveChildren ? 'group' : (_provided$dragHandleP = provided.dragHandleProps) === null || _provided$dragHandleP === void 0 ? void 0 : _provided$dragHandleP.role
      // If the container includes an interactive element, we remove the tabindex=0
      // because [role="group"] does not permit or warrant a tab stop
      // additionally we remove the tabindex when the child is a fully custom handle
      // that has its own tabindex and handle props
      ,
      tabIndex: hasInteractiveChildren || isFullyCustomDragHandle ? undefined : (_provided$dragHandleP2 = provided.dragHandleProps) === null || _provided$dragHandleP2 === void 0 ? void 0 : _provided$dragHandleP2.tabIndex
    }), cloneElementWithCss(DraggableElement, {
      className: classNames(DraggableElement.props.className, childClasses),
      css: [euiDraggableItemStyles.euiDraggable__item, isDragDisabled && euiDraggableItemStyles.disabled]
    })), cloneItems && isDragging && ___EmotionJSX("div", {
      className: classNames(classes, 'euiDraggable--clone'),
      css: cssStyles
    }, DraggableElement));
    return isDragging && usePortal ? ___EmotionJSX(EuiPortal, null, content) : content;
  });
};
EuiDraggable.propTypes = {
  /**
     * ReactNode to render as this component's content
     */
  children: PropTypes.oneOfType([PropTypes.element.isRequired, PropTypes.any.isRequired]).isRequired,
  className: PropTypes.string,
  /**
     * Whether the `children` will provide and set up its own drag handle.
     * The `custom` value additionally removes the `role` from the draggable container.
     * Use this if the `children` element is focusable and should keep its
     * semantic role for accessibility purposes.
     */
  customDragHandle: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.oneOf(["custom"])]),
  /**
     * Whether the container has interactive children and should have `role="group"` instead of `"button"`.
     * Setting this flag ensures your drag & drop container is keyboard and screen reader accessible.
     */
  hasInteractiveChildren: PropTypes.bool,
  /**
     * Whether the item is currently in a position to be removed
     */
  isRemovable: PropTypes.bool,
  /**
     * Whether the currently dragged item is cloned into a portal in the body. This settings will
     * ensure that drag & drop still works as expected within stacking contexts (e.g. within `EuiFlyout`,
     * `EuiModal` and `EuiPopover`).
     *
     * Make sure to apply styles directly to the Draggable content as relative styling from an outside
     * scope might not be applied when the content is placed in a portal as the DOM structure changes.
     */
  usePortal: PropTypes.bool,
  /**
     * Adds padding to the draggable item
     */
  spacing: PropTypes.any,
  style: PropTypes.any,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any
};