var _excluded = ["droppableId", "direction", "isDropDisabled", "children", "className", "cloneDraggables", "spacing", "style", "type", "withPanel", "grow", "data-test-subj"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useContext } from 'react';
import PropTypes from "prop-types";
import { Droppable } from '@hello-pangea/dnd';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { EuiPanel } from '../panel';
import { EuiDragDropContextContext } from './drag_drop_context';
import { euiDroppableStyles } from './droppable.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var SPACINGS = ['none', 's', 'm', 'l'];
export var EuiDroppableContext = /*#__PURE__*/React.createContext({
  cloneItems: false
});
export var EuiDroppable = function EuiDroppable(_ref) {
  var droppableId = _ref.droppableId,
    direction = _ref.direction,
    _ref$isDropDisabled = _ref.isDropDisabled,
    isDropDisabled = _ref$isDropDisabled === void 0 ? false : _ref$isDropDisabled,
    children = _ref.children,
    className = _ref.className,
    _ref$cloneDraggables = _ref.cloneDraggables,
    cloneDraggables = _ref$cloneDraggables === void 0 ? false : _ref$cloneDraggables,
    _ref$spacing = _ref.spacing,
    spacing = _ref$spacing === void 0 ? 'none' : _ref$spacing,
    style = _ref.style,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'EUI_DEFAULT' : _ref$type,
    _ref$withPanel = _ref.withPanel,
    withPanel = _ref$withPanel === void 0 ? false : _ref$withPanel,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? false : _ref$grow,
    _ref$dataTestSubj = _ref['data-test-subj'],
    dataTestSubj = _ref$dataTestSubj === void 0 ? 'droppable' : _ref$dataTestSubj,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useContext = useContext(EuiDragDropContextContext),
    isDraggingType = _useContext.isDraggingType;
  var dropIsDisabled = cloneDraggables ? true : isDropDisabled;
  var styles = useEuiMemoizedStyles(euiDroppableStyles);
  return ___EmotionJSX(Droppable, _extends({
    isDropDisabled: dropIsDisabled,
    droppableId: droppableId,
    direction: direction,
    type: type
  }, rest), function (provided, snapshot) {
    var isDraggingOver = snapshot.isDraggingOver;
    var PanelOrDiv = withPanel ? EuiPanel : 'div';
    var panelOrDivProps = withPanel ? {
      panelRef: provided.innerRef,
      hasShadow: true,
      paddingSize: 'none'
    } : {
      ref: provided.innerRef
    };
    var cssStyles = [styles.euiDroppable, isDraggingType === type && !dropIsDisabled && styles.isDragging, isDraggingOver && styles.isDraggingOver, grow ? styles.grow : styles.noGrow, styles.spacing[spacing]];
    var classes = classNames('euiDroppable', {
      'euiDroppable-isDisabled': dropIsDisabled
    }, className);
    var DroppableElement = typeof children === 'function' ? children(provided, snapshot) : children;
    return ___EmotionJSX(PanelOrDiv, _extends({}, provided.droppableProps, panelOrDivProps, {
      style: style,
      "data-test-subj": dataTestSubj,
      className: classes,
      css: cssStyles
    }), ___EmotionJSX(EuiDroppableContext.Provider, {
      value: {
        cloneItems: cloneDraggables
      }
    }, DroppableElement), ___EmotionJSX("div", {
      className: "euiDroppable__placeholder",
      hidden: cloneDraggables
    }, provided.placeholder));
  });
};
EuiDroppable.propTypes = {
  /**
     * ReactNode to render as this component's content
     */
  children: PropTypes.oneOfType([PropTypes.element.isRequired, PropTypes.arrayOf(PropTypes.element.isRequired).isRequired, PropTypes.any.isRequired]).isRequired,
  className: PropTypes.string,
  /**
     * Makes its items immutable. Dragging creates cloned items that can be dropped elsewhere.
     */
  cloneDraggables: PropTypes.bool,
  style: PropTypes.any,
  /**
     * Adds padding to the droppable area
     */
  spacing: PropTypes.any,
  /**
     * Adds an EuiPanel style to the droppable area
     */
  withPanel: PropTypes.bool,
  /**
     * Allow the panel to flex-grow?
     */
  grow: PropTypes.bool,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any
};