function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { transparentize } from '../../services';
import { euiCanAnimate } from '../../global_styling';
var _ref = process.env.NODE_ENV === "production" ? {
  name: "jkp921-noGrow",
  styles: "flex-grow:0;label:noGrow;"
} : {
  name: "jkp921-noGrow",
  styles: "flex-grow:0;label:noGrow;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "122lw0e-grow",
  styles: "flex-grow:1;label:grow;"
} : {
  name: "122lw0e-grow",
  styles: "flex-grow:1;label:grow;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiDroppableStyles = function euiDroppableStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var droppableColor = euiTheme.colors.success;
  return {
    euiDroppable: /*#__PURE__*/css(euiCanAnimate, "{transition:background-color ", euiTheme.animation.slow, " ease;};label:euiDroppable;"),
    isDragging: /*#__PURE__*/css("background-color:", transparentize(droppableColor, 0.1), ";;label:isDragging;"),
    isDraggingOver: /*#__PURE__*/css("background-color:", transparentize(droppableColor, 0.25), ";;label:isDraggingOver;"),
    grow: _ref2,
    noGrow: _ref,
    spacing: sharedSpacingPadding(euiThemeContext)
  };
};

// Droppable and draggable components both have the same shared spacing/padding values
export var sharedSpacingPadding = function sharedSpacingPadding(_ref3) {
  var euiTheme = _ref3.euiTheme;
  return {
    none: null,
    s: /*#__PURE__*/css("padding:", euiTheme.size.xxs, ";;label:s;"),
    m: /*#__PURE__*/css("padding:", euiTheme.size.xs, ";;label:m;"),
    l: /*#__PURE__*/css("padding:", euiTheme.size.s, ";;label:l;")
  };
};