var _excluded = ["icon", "iconType", "iconColor", "title", "titleSize", "paddingSize", "body", "actions", "className", "layout", "hasBorder", "color", "footer"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { EuiTitle } from '../title';
import { EuiFlexGroup, EuiFlexItem } from '../flex';
import { EuiSpacer } from '../spacer';
import { EuiIcon } from '../icon';
import { isNamedColor } from '../icon/named_colors';
import { EuiText } from '../text';
import { EuiPanel } from '../panel/panel';
import { euiEmptyPromptStyles } from './empty_prompt.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var PADDING_SIZES = ['none', 's', 'm', 'l'];
export var EuiEmptyPrompt = function EuiEmptyPrompt(_ref) {
  var icon = _ref.icon,
    iconType = _ref.iconType,
    _iconColor = _ref.iconColor,
    title = _ref.title,
    _ref$titleSize = _ref.titleSize,
    titleSize = _ref$titleSize === void 0 ? 'm' : _ref$titleSize,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
    body = _ref.body,
    actions = _ref.actions,
    className = _ref.className,
    _ref$layout = _ref.layout,
    layout = _ref$layout === void 0 ? 'vertical' : _ref$layout,
    hasBorder = _ref.hasBorder,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'transparent' : _ref$color,
    footer = _ref.footer,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiEmptyPrompt', className);
  var styles = useEuiMemoizedStyles(euiEmptyPromptStyles);
  var cssStyles = [styles.euiEmptyPrompt, styles[layout]];
  var mainStyles = [styles.main.euiEmptyPrompt__main, styles.main[layout], styles.main[paddingSize], layout === 'horizontal' && styles.main.horizontalPadding[paddingSize]];
  var contentStyles = [styles.content.euiEmptyPrompt__content, styles.content[layout]];

  // Default the iconColor to `subdued`,
  // otherwise try to match the iconColor with the panel color unless iconColor is specified
  var iconColor = _iconColor !== null && _iconColor !== void 0 ? _iconColor : isNamedColor(color) ? color : 'subdued';
  var iconNode = useMemo(function () {
    if (!iconType && !icon) return null;
    var iconStyles = [styles.icon.euiEmptyPrompt__icon, styles.icon[layout]];
    return ___EmotionJSX("div", {
      className: "euiEmptyPrompt__icon",
      css: iconStyles
    }, iconType ? ___EmotionJSX(EuiIcon, {
      type: iconType,
      size: "xxl",
      color: iconColor
    }) : icon);
  }, [icon, iconType, iconColor, layout, styles.icon]);
  var actionsNode = useMemo(function () {
    if (!actions) return null;
    if (Array.isArray(actions)) {
      var actionStyles = [styles.actions.euiEmptyPrompt__actions, styles.actions[layout]];
      return ___EmotionJSX(EuiFlexGroup, {
        className: "euiEmptyPrompt__actions",
        css: actionStyles,
        gutterSize: "m",
        alignItems: "center",
        justifyContent: "center",
        direction: layout === 'vertical' ? 'column' : 'row'
      }, actions.map(function (action, index) {
        return ___EmotionJSX(EuiFlexItem, {
          key: index,
          grow: false
        }, action);
      }));
    } else {
      return actions;
    }
  }, [actions, layout, styles.actions]);
  var footerNode = useMemo(function () {
    if (!footer) return null;
    var footerStyles = [styles.footer.euiEmptyPrompt__footer, styles.footer[paddingSize], styles.footer[color], color === 'transparent' && !hasBorder && styles.footer.roundedBorders];
    return ___EmotionJSX("div", {
      className: "euiEmptyPrompt__footer",
      css: footerStyles
    }, footer);
  }, [footer, paddingSize, color, hasBorder, styles.footer]);
  return ___EmotionJSX(EuiPanel, _extends({
    css: cssStyles,
    className: classes,
    color: color,
    paddingSize: "none",
    grow: false,
    hasBorder: hasBorder
  }, rest), ___EmotionJSX("div", {
    className: "euiEmptyPrompt__main",
    css: mainStyles
  }, iconNode, ___EmotionJSX("div", {
    className: "euiEmptyPrompt__content",
    css: contentStyles
  }, title && ___EmotionJSX(EuiTitle, {
    size: titleSize
  }, title), title && body && ___EmotionJSX(EuiSpacer, {
    size: "m"
  }), body && ___EmotionJSX(EuiText, {
    color: "subdued"
  }, body), actionsNode && (body || title) && ___EmotionJSX(EuiSpacer, {
    size: "l"
  }), actionsNode)), footerNode);
};
EuiEmptyPrompt.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
     * Adds a medium shadow to the panel;
     * Only works when `color="plain"`
     */
  hasShadow: PropTypes.bool,
  /**
     * Adds a slight 1px border on all edges.
     * Only works when `color="plain | transparent"`
     */
  hasBorder: PropTypes.bool,
  /**
     * Background color of the panel;
     * Usually a lightened form of the brand colors
     */
  color: PropTypes.any,
  /*
       * Accepts any [EuiIcon.type](#/display/icons)
       */
  iconType: PropTypes.oneOfType([PropTypes.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "anomalyChart", "anomalySwimLane", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "changePointDetection", "check", "checkInCircleFilled", "cheer", "classificationJob", "clickLeft", "clickRight", "clock", "clockCounter", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "codeApp", "color", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "contrast", "contrastHigh", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createGenericJob", "createGeoJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInCircle", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "errorFilled", "esqlVis", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "fieldStatistics", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logPatternAnalysis", "logRateAnalysis", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "minusInSquare", "mobile", "monitoringApp", "moon", "move", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "plusInSquare", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "section", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "singleMetricViewer", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "warningFilled", "alert", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDimension", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenSemanticText", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, PropTypes.string.isRequired, PropTypes.elementType.isRequired]),
  /**
       * Color for `iconType` when passed as an `IconType`
       */
  iconColor: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.any.isRequired]),
  /**
       * Custom icon replacing the one generated by `iconType`
       */
  icon: PropTypes.node,
  /**
       * Requires passing a single element that gets wrapped in an EuiTitle.
       * Recommendation is a heading, preferrably an `<h2>` if in its own section
       */
  title: PropTypes.element,
  /**
       * Choose from one of the `EuiTitle.size` options
       */
  titleSize: PropTypes.any,
  /**
       * Gets wrapped in a subdued EuiText block.
       * Recommendation is to pass typical text elements like `<p>`
       */
  body: PropTypes.node,
  /**
       * Pass a single or an array of actions (buttons) that get stacked at the bottom.
       * Recommendation is to pass the primary action first and secondary actions as empty buttons
       */
  actions: PropTypes.node,
  /**
       * Optionally provide a footer. Accepts any combination of elements.
       */
  footer: PropTypes.node,
  /**
       * Sets the layout. When `horizontal` the icon goes to the right column.
       */
  layout: PropTypes.oneOf(["vertical", "horizontal"]),
  /**
       * Padding applied around the content and footer.
       */
  paddingSize: PropTypes.any
};