/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React from 'react';
import { EuiButton } from '../button';
import { EuiErrorBoundary } from './error_boundary';
import { EuiSpacer } from '../spacer';
import { jsx as ___EmotionJSX } from "@emotion/react";
var handleFocus = function handleFocus() {
  var target = document.querySelector('pre.euiCodeBlock__pre');
  target.focus();
};
describe('EuiErrorBoundary', function () {
  describe('Automated accessibility check when an error is thrown', function () {
    var BadComponent = function BadComponent() {
      throw new Error('Throw the error.');
    };
    beforeEach(function () {
      cy.on('uncaught:exception', function (err) {
        if (err.message.includes('Throw the error')) {
          return false;
        }
      });
      cy.viewport(1024, 768); // medium breakpoint
      cy.realMount(___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiButton, {
        color: "primary",
        onClick: handleFocus,
        "data-test-subj": "cy-error-boundary-button"
      }, "Press to focus"), ___EmotionJSX(EuiSpacer, null), ___EmotionJSX(EuiErrorBoundary, null, ___EmotionJSX(BadComponent, null))));
    });
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations and accepts focus when the button is pressed', function () {
      cy.get('button').first().focus();
      cy.realPress('Enter');
      cy.get('pre.euiCodeBlock__pre').should('have.focus');
      cy.checkAxe();
    });
  });
  describe('Automated accessibility check when no error is thrown', function () {
    var GoodComponent = function GoodComponent() {
      return ___EmotionJSX("div", {
        "data-test-subj": "cy-good-component"
      }, "This is a properly rendered component.");
    };
    beforeEach(function () {
      cy.viewport(1024, 768); // medium breakpoint
      cy.realMount(___EmotionJSX(EuiErrorBoundary, null, ___EmotionJSX(GoodComponent, null)));
    });
    it('has zero violations when no violations are thrown', function () {
      cy.get('div[data-test-subj="cy-good-component"]').should('exist');
      cy.checkAxe();
    });
  });
});