function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["children"],
  _excluded2 = ["errorMessage", "className", "data-test-subj"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { EuiTitle } from '../title';
import { EuiCodeBlock } from '../code';
import { EuiI18n } from '../i18n';
import { euiErrorBoundaryStyles } from './error_boundary.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiErrorBoundary = /*#__PURE__*/function (_Component) {
  function EuiErrorBoundary(props) {
    var _this;
    _classCallCheck(this, EuiErrorBoundary);
    _this = _callSuper(this, EuiErrorBoundary, [props]);
    var errorState = {
      hasError: false,
      errorMessage: undefined
    };
    _this.state = errorState;
    return _this;
  }
  _inherits(EuiErrorBoundary, _Component);
  return _createClass(EuiErrorBoundary, [{
    key: "componentDidCatch",
    value: function componentDidCatch(error) {
      var _this$props$onError, _this$props;
      // Display fallback UI
      // Only Chrome includes the `message` property as part of `stack`.
      // For consistency, rebuild the full error text from the Error subparts.
      var message = error.message,
        stack = error.stack;
      var idx = (stack === null || stack === void 0 ? void 0 : stack.indexOf(message)) || -1;
      var stackStr = idx > -1 ? stack === null || stack === void 0 ? void 0 : stack.substring(idx + message.length + 1) : stack;
      var errorMessage = "Error: ".concat(message, "\n").concat(stackStr);
      this.setState({
        hasError: true,
        errorMessage: errorMessage
      });

      // Pass back the error to the consumer
      (_this$props$onError = (_this$props = this.props).onError) === null || _this$props$onError === void 0 || _this$props$onError.call(_this$props, error);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        children = _this$props2.children,
        rest = _objectWithoutProperties(_this$props2, _excluded);
      var _this$state = this.state,
        hasError = _this$state.hasError,
        errorMessage = _this$state.errorMessage;
      if (hasError) {
        // You can render any custom fallback UI
        return ___EmotionJSX(EuiErrorMessage, _extends({}, rest, {
          errorMessage: errorMessage
        }));
      }
      return children;
    }
  }]);
}(Component);

/**
 * Split out into a separate styling-only component for easier use of hooks,
 * and also for internal re-use by EUI's docs/playgrounds
 */
EuiErrorBoundary.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
       * ReactNode to render as this component's content
       */
  children: PropTypes.node.isRequired,
  /**
       * Callback that fires when an error is caught. Passes back the full error
       */
  onError: PropTypes.func
};
export var EuiErrorMessage = function EuiErrorMessage(_ref) {
  var errorMessage = _ref.errorMessage,
    className = _ref.className,
    dataTestSubj = _ref['data-test-subj'],
    rest = _objectWithoutProperties(_ref, _excluded2);
  var styles = useEuiMemoizedStyles(euiErrorBoundaryStyles);
  return ___EmotionJSX("div", _extends({
    css: styles.euiErrorBoundary,
    className: classNames('euiErrorBoundary', className),
    "data-test-subj": classNames('euiErrorBoundary', dataTestSubj)
  }, rest), ___EmotionJSX(EuiCodeBlock, null, ___EmotionJSX(EuiTitle, {
    size: "xs"
  }, ___EmotionJSX("p", null, ___EmotionJSX(EuiI18n, {
    token: "euiErrorBoundary.error",
    default: "Error"
  }))), errorMessage));
};
EuiErrorMessage.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  errorMessage: PropTypes.string
};