function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["className", "description", "descriptionProps", "value", "valueProps", "color", "uppercase", "isActive", "display", "descriptionWidth", "onClick", "isInvalid", "textWrap"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { EuiIcon } from '../icon';
import { useEuiTheme } from '../../services';
import { euiExpressionStyles, euiExpressionDescriptionStyles, euiExpressionValueStyles, euiExpressionIconStyles } from './expression.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var COLORS = ['subdued', 'primary', 'success', 'accent', 'warning', 'danger'];
export var EuiExpression = function EuiExpression(_ref) {
  var className = _ref.className,
    description = _ref.description,
    descriptionProps = _ref.descriptionProps,
    value = _ref.value,
    valueProps = _ref.valueProps,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'success' : _ref$color,
    _ref$uppercase = _ref.uppercase,
    uppercase = _ref$uppercase === void 0 ? true : _ref$uppercase,
    _ref$isActive = _ref.isActive,
    isActive = _ref$isActive === void 0 ? false : _ref$isActive,
    _ref$display = _ref.display,
    display = _ref$display === void 0 ? 'inline' : _ref$display,
    _ref$descriptionWidth = _ref.descriptionWidth,
    descriptionWidth = _ref$descriptionWidth === void 0 ? '20%' : _ref$descriptionWidth,
    onClick = _ref.onClick,
    _ref$isInvalid = _ref.isInvalid,
    isInvalid = _ref$isInvalid === void 0 ? false : _ref$isInvalid,
    _ref$textWrap = _ref.textWrap,
    textWrap = _ref$textWrap === void 0 ? 'break-word' : _ref$textWrap,
    rest = _objectWithoutProperties(_ref, _excluded);
  var calculatedColor = isInvalid ? 'danger' : color;
  var theme = useEuiTheme();
  var styles = euiExpressionStyles(theme);
  var cssStyles = [styles.euiExpression, onClick && styles.isClickable, styles[color], isActive && styles.isActive.base, isActive && styles.isActive[color], display === 'columns' && styles.columns, textWrap === 'truncate' && styles.truncate];
  var descriptionStyles = euiExpressionDescriptionStyles(theme);
  var cssDescriptionStyles = [descriptionStyles.euiExpression__description, isInvalid ? descriptionStyles.danger : descriptionStyles[color], uppercase && descriptionStyles.isUppercase, textWrap === 'truncate' && descriptionStyles.truncate, display === 'columns' && descriptionStyles.columns];
  var valueStyles = euiExpressionValueStyles(theme);
  var cssValueStyles = [valueStyles.euiExpression__value, textWrap === 'truncate' && valueStyles.truncate, display === 'columns' && valueStyles.columns];
  var iconStyles = euiExpressionIconStyles(theme);
  var cssIconStyles = [iconStyles.euiExpression__icon, display === 'columns' && iconStyles.columns];
  var classes = classNames('euiExpression', className);
  var Component = onClick ? 'button' : 'span';
  var customWidth = display === 'columns' && descriptionWidth ? {
    flexBasis: descriptionWidth
  } : undefined;
  var invalidIcon = isInvalid ? ___EmotionJSX(EuiIcon, {
    className: "euiExpression__icon",
    type: "warning",
    css: cssIconStyles,
    color: calculatedColor
  }) : undefined;
  return ___EmotionJSX(Component, _extends({
    css: cssStyles,
    className: classes,
    onClick: onClick
  }, rest), ___EmotionJSX("span", _extends({}, descriptionProps, {
    className: classNames('euiExpression__description', descriptionProps === null || descriptionProps === void 0 ? void 0 : descriptionProps.className),
    css: [].concat(cssDescriptionStyles, [descriptionProps === null || descriptionProps === void 0 ? void 0 : descriptionProps.css]),
    style: _objectSpread(_objectSpread({}, customWidth), descriptionProps === null || descriptionProps === void 0 ? void 0 : descriptionProps.style)
  }), description), ' ', value && ___EmotionJSX("span", _extends({}, valueProps, {
    className: classNames('euiExpression__value', valueProps === null || valueProps === void 0 ? void 0 : valueProps.className),
    css: [].concat(cssValueStyles, [valueProps === null || valueProps === void 0 ? void 0 : valueProps.css])
  }), value), invalidIcon);
};
EuiExpression.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
     * First part of the expression
     */
  /**
     * First part of the expression
     */
  description: PropTypes.node.isRequired,
  descriptionProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }),
  /**
     * Second part of the expression
     */
  /**
     * Second part of the expression
     */
  value: PropTypes.node,
  valueProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }),
  /**
     * Color of the `description`
     */
  /**
     * Color of the `description`
     */
  color: PropTypes.any,
  /**
     * Should the `description` auto-uppercase?
     */
  /**
     * Should the `description` auto-uppercase?
     */
  uppercase: PropTypes.bool,
  /**
     * Adds an solid border at the bottom
     */
  /**
     * Adds an solid border at the bottom
     */
  isActive: PropTypes.bool,
  /**
     * Turns the component into a button and adds an editable style border at the bottom
     */
  /**
     * Turns the component into a button and adds an editable style border at the bottom
     */
  onClick: PropTypes.oneOfType([PropTypes.oneOfType([PropTypes.func, PropTypes.func.isRequired]), PropTypes.func]),
  /**
     * Sets the display style for the expression. Defaults to `inline`
     */
  /**
     * Sets the display style for the expression. Defaults to `inline`
     */
  display: PropTypes.oneOf(["inline", "columns"]),
  /**
     * Forces color to display as `danger` and shows an `error` icon
     */
  /**
     * Forces color to display as `danger` and shows an `error` icon
     */
  isInvalid: PropTypes.bool,
  /**
     * Sets a custom width for the description when using the columns layout.
     * Set to a number for a custom width in `px`.
     * Set to a string for a custom width in custom measurement.
     * Defaults to `20%`
     */
  /**
     * Sets a custom width for the description when using the columns layout.
     * Set to a number for a custom width in `px`.
     * Set to a string for a custom width in custom measurement.
     * Defaults to `20%`
     */
  descriptionWidth: PropTypes.oneOfType([PropTypes.number.isRequired, PropTypes.string.isRequired]),
  /**
     * Sets how to handle the wrapping of long text.
     */
  /**
     * Sets how to handle the wrapping of long text.
     */
  textWrap: PropTypes.oneOf(["break-word", "truncate"])
};