function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, mathWithUnits, euiBreakpoint } from '../../global_styling';
import { euiFormVariables } from '../form/form.styles';
import { euiFilterButtonDisplay } from './filter_button.styles';
var _ref = process.env.NODE_ENV === "production" ? {
  name: "ejknuq-fullWidth",
  styles: "display:flex;label:fullWidth;"
} : {
  name: "ejknuq-fullWidth",
  styles: "display:flex;label:fullWidth;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiFilterGroupStyles = function euiFilterGroupStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiFormVariables = euiFormVariables(euiThemeContext),
    backgroundColor = _euiFormVariables.backgroundColor,
    borderColor = _euiFormVariables.borderColor,
    controlBorderRadius = _euiFormVariables.controlBorderRadius,
    controlCompressedBorderRadius = _euiFormVariables.controlCompressedBorderRadius,
    controlCompressedHeight = _euiFormVariables.controlCompressedHeight;
  return {
    euiFilterGroup: /*#__PURE__*/css("display:inline-flex;", logicalCSS('max-width', '100%'), " overflow:hidden;background-color:", backgroundColor, ";box-shadow:inset 0 0 0 ", euiTheme.border.width.thin, " ", borderColor, ";>*:not(.euiFilterButton){", euiFilterButtonDisplay(euiThemeContext), ";}.euiPopover>.euiFilterButton{", logicalCSS('width', '100%'), ";}", euiBreakpoint(euiThemeContext, ['xs', 's']), "{flex-wrap:wrap;}", euiBreakpoint(euiThemeContext, ['xs']), "{display:flex;.euiFilterButton{flex-grow:1;}};label:euiFilterGroup;"),
    fullWidth: _ref,
    uncompressed: /*#__PURE__*/css("border-radius:", controlBorderRadius, ";", buttonChildrenBorderRadii(controlBorderRadius), ";;label:uncompressed;"),
    compressed: /*#__PURE__*/css("border-radius:", controlCompressedBorderRadius, ";", buttonChildrenBorderRadii(controlCompressedBorderRadius), " .euiFilterButton{", logicalCSS('height', controlCompressedHeight), ";};label:compressed;"),
    /**
     * Not used in EuiFilterGroup directly, but used by EuiSearchBar and consumers
     * A fixed width is required because of the shift in widths that can be caused
     * by the loading animation that precedes the results.
     */
    euiFilterGroup__popoverPanel: /*#__PURE__*/css(logicalCSS('width', mathWithUnits(euiTheme.size.base, function (x) {
      return x * 18;
    })), ";;label:euiFilterGroup__popoverPanel;")
  };
};

/**
 * Small util for manually rounding the borders of the first and last EuiFilterButtons
 * - this makes their focus rings appear nicely instead of being cutt off.
 * 2nd selector accounts for EuiFilterButtons nested within popover/tooltip wrappers.
 *
 * NOTE: Do not use `logicalShorthandCSS()` here, as that will cause single buttons to not be rounded
 */
var buttonChildrenBorderRadii = function buttonChildrenBorderRadii(radiusSize) {
  return "\n  > :first-child,\n  > :first-child .euiFilterButton {\n    ".concat(logicalCSS('border-top-left-radius', radiusSize), "\n    ").concat(logicalCSS('border-bottom-left-radius', radiusSize), "\n  }\n\n  > :last-child,\n  > :last-child .euiFilterButton {\n    ").concat(logicalCSS('border-top-right-radius', radiusSize), "\n    ").concat(logicalCSS('border-bottom-right-radius', radiusSize), "\n  }\n");
};