/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { transparentize } from '../../services';
import { logicalCSS, logicalShorthandCSS, logicalTextAlignCSS, euiFontSize } from '../../global_styling';
export var euiFilterSelectItemStyles = function euiFilterSelectItemStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var focusStyles = "\n    color: ".concat(euiTheme.colors.primary, ";\n    background-color: ").concat(euiTheme.focus.backgroundColor, ";\n    outline-offset: -").concat(euiTheme.focus.width, ";\n    text-decoration: underline;\n\n    &:disabled {\n      background-color: ").concat(transparentize(euiTheme.colors.disabled, 0.1), ";\n    }\n  ");
  return {
    euiFilterSelectItem: /*#__PURE__*/css("display:block;", logicalCSS('width', '100%'), " ", logicalShorthandCSS('padding', "".concat(euiTheme.size.xs, " ").concat(euiTheme.size.m)), " ", euiFontSize(euiThemeContext, 's'), " ", logicalTextAlignCSS('left'), " color:", euiTheme.colors.text, ";", logicalCSS('border-bottom', "".concat(euiTheme.border.width.thin, " solid ").concat(euiTheme.colors.lightestShade)), " &:hover{cursor:pointer;text-decoration:underline;}&:focus{", focusStyles, ";}&:disabled{cursor:not-allowed;text-decoration:none;color:", euiTheme.colors.disabledText, ";};label:euiFilterSelectItem;"),
    isFocused: /*#__PURE__*/css(focusStyles, ";;label:isFocused;")
  };
};