function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["children", "className", "style", "gutterSize", "direction", "alignItems", "responsive", "columns", "component"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { euiFlexGridStyles } from './flex_grid.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var DIRECTIONS = ['row', 'column'];
export var ALIGN_ITEMS = ['stretch', 'start', 'end', 'center', 'baseline'];
export var GUTTER_SIZES = ['none', 's', 'm', 'l', 'xl'];
export var EuiFlexGrid = function EuiFlexGrid(_ref) {
  var children = _ref.children,
    className = _ref.className,
    style = _ref.style,
    _ref$gutterSize = _ref.gutterSize,
    gutterSize = _ref$gutterSize === void 0 ? 'l' : _ref$gutterSize,
    _ref$direction = _ref.direction,
    direction = _ref$direction === void 0 ? 'row' : _ref$direction,
    _ref$alignItems = _ref.alignItems,
    alignItems = _ref$alignItems === void 0 ? 'stretch' : _ref$alignItems,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? true : _ref$responsive,
    _ref$columns = _ref.columns,
    columns = _ref$columns === void 0 ? 1 : _ref$columns,
    _ref$component = _ref.component,
    Component = _ref$component === void 0 ? 'div' : _ref$component,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiFlexGrid', className);
  var styles = useEuiMemoizedStyles(euiFlexGridStyles);
  var cssStyles = [styles.euiFlexGrid, styles.gutterSizes[gutterSize], styles.direction[direction], styles.alignItems[alignItems], styles.columnCount[columns], responsive && styles.responsive];
  var columnDirectionStyles = useMemo(function () {
    if (direction === 'column') {
      var rowsToRender = Math.ceil(React.Children.count(children) / columns);
      return {
        gridTemplateRows: "repeat(".concat(rowsToRender, ", 1fr)")
      };
    }
  }, [direction, columns, children]);
  return ___EmotionJSX(Component, _extends({
    css: cssStyles,
    className: classes,
    style: columnDirectionStyles ? _objectSpread(_objectSpread({}, style), columnDirectionStyles) : style
  }, rest), children);
};
EuiFlexGrid.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
     * ReactNode to render as this component's content
     */
  children: PropTypes.node,
  /**
     * Number of columns. Accepts `1-4`
     */
  columns: PropTypes.oneOf([1, 2, 3, 4]),
  // Leave this as inline so the props table correctly parses it
  /**
     * Flex layouts default to left-right then top-down (`row`).
     * Change this prop to `column` to create a top-down then left-right display.
     */
  direction: PropTypes.any,
  /**
     * Aligns grid items vertically
     */
  alignItems: PropTypes.any,
  /**
     * Space between flex items
     */
  gutterSize: PropTypes.any,
  /**
     * Will display each item at full-width on smaller screens
     */
  responsive: PropTypes.bool,
  /**
     * The tag to render
     * @default div
     */
  component: PropTypes.any
};