/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiMaxBreakpoint, euiMinBreakpoint, logicalCSS } from '../../global_styling';
import { euiShadowXLarge } from '../../themes/amsterdam/global_styling/mixins';
import { transparentize } from '../../services';
import { FLYOUT_BREAKPOINT } from './flyout.styles';
export var euiFlyoutCloseButtonStyles = function euiFlyoutCloseButtonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiFlyout__closeButton: /*#__PURE__*/css("position:absolute;", logicalCSS('right', euiTheme.size.s), " ", logicalCSS('top', euiTheme.size.s), " z-index:3;;label:euiFlyout__closeButton;"),
    inside: /*#__PURE__*/css("background-color:", transparentize(euiTheme.colors.emptyShade, 0.9), ";;label:inside;"),
    outside: /*#__PURE__*/css(euiShadowXLarge(euiThemeContext), "animation:none!important;;label:outside;"),
    outsideSide: {
      // `transforms` pull in close buttons a little
      // `!important` is necessary here to override the hover/focus transitions of buttons
      right: /*#__PURE__*/css(logicalCSS('left', 0), " ", euiMaxBreakpoint(euiThemeContext, FLYOUT_BREAKPOINT), "{transform:translateX(calc(-100% - ", euiTheme.size.xs, "))!important;}", euiMinBreakpoint(euiThemeContext, FLYOUT_BREAKPOINT), "{transform:translateX(calc(-100% - ", euiTheme.size.l, "))!important;};label:right;"),
      left: /*#__PURE__*/css(logicalCSS('right', 0), " ", euiMaxBreakpoint(euiThemeContext, FLYOUT_BREAKPOINT), "{transform:translateX(calc(100% + ", euiTheme.size.xs, "))!important;}", euiMinBreakpoint(euiThemeContext, FLYOUT_BREAKPOINT), "{transform:translateX(calc(100% + ", euiTheme.size.l, "))!important;};label:left;")
    }
  };
};