function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["className", "children", "as", "hideCloseButton", "closeButtonProps", "closeButtonPosition", "onClose", "ownFocus", "side", "size", "paddingSize", "maxWidth", "style", "maskProps", "type", "outsideClickCloses", "pushMinBreakpoint", "pushAnimation", "focusTrapProps", "includeFixedHeadersInFocusTrap", "aria-describedby"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
import PropTypes from "prop-types";
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useEffect, useRef, useMemo, useCallback, useState, forwardRef } from 'react';
import classnames from 'classnames';
import { keys, EuiWindowEvent, useCombinedRefs, useIsWithinMinBreakpoint, useEuiMemoizedStyles, useGeneratedHtmlId } from '../../services';
import { logicalStyle } from '../../global_styling';
import { EuiFocusTrap } from '../focus_trap';
import { EuiOverlayMask } from '../overlay_mask';
import { EuiI18n } from '../i18n';
import { useResizeObserver } from '../observer/resize_observer';
import { EuiPortal } from '../portal';
import { EuiScreenReaderOnly } from '../accessibility';
import { EuiFlyoutCloseButton } from './_flyout_close_button';
import { euiFlyoutStyles } from './flyout.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var TYPES = ['push', 'overlay'];
export var SIDES = ['left', 'right'];
export var SIZES = ['s', 'm', 'l'];
/**
 * Custom type checker for named flyout sizes since the prop
 * `size` can also be CSSProperties['width'] (string | number)
 */
function isEuiFlyoutSizeNamed(value) {
  return SIZES.includes(value);
}
export var PADDING_SIZES = ['none', 's', 'm', 'l'];
var defaultElement = 'div';
export var EuiFlyout = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var className = _ref.className,
    children = _ref.children,
    as = _ref.as,
    _ref$hideCloseButton = _ref.hideCloseButton,
    hideCloseButton = _ref$hideCloseButton === void 0 ? false : _ref$hideCloseButton,
    closeButtonProps = _ref.closeButtonProps,
    _ref$closeButtonPosit = _ref.closeButtonPosition,
    closeButtonPosition = _ref$closeButtonPosit === void 0 ? 'inside' : _ref$closeButtonPosit,
    onClose = _ref.onClose,
    _ref$ownFocus = _ref.ownFocus,
    ownFocus = _ref$ownFocus === void 0 ? true : _ref$ownFocus,
    _ref$side = _ref.side,
    side = _ref$side === void 0 ? 'right' : _ref$side,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
    _ref$maxWidth = _ref.maxWidth,
    maxWidth = _ref$maxWidth === void 0 ? false : _ref$maxWidth,
    style = _ref.style,
    maskProps = _ref.maskProps,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'overlay' : _ref$type,
    outsideClickCloses = _ref.outsideClickCloses,
    _ref$pushMinBreakpoin = _ref.pushMinBreakpoint,
    pushMinBreakpoint = _ref$pushMinBreakpoin === void 0 ? 'l' : _ref$pushMinBreakpoin,
    _ref$pushAnimation = _ref.pushAnimation,
    pushAnimation = _ref$pushAnimation === void 0 ? false : _ref$pushAnimation,
    _focusTrapProps = _ref.focusTrapProps,
    _ref$includeFixedHead = _ref.includeFixedHeadersInFocusTrap,
    includeFixedHeadersInFocusTrap = _ref$includeFixedHead === void 0 ? true : _ref$includeFixedHead,
    _ariaDescribedBy = _ref['aria-describedby'],
    rest = _objectWithoutProperties(_ref, _excluded);
  var Element = as || defaultElement;
  var maskRef = useRef(null);
  var windowIsLargeEnoughToPush = useIsWithinMinBreakpoint(pushMinBreakpoint);
  var isPushed = type === 'push' && windowIsLargeEnoughToPush;

  /**
   * Setting up the refs on the actual flyout element in order to
   * accommodate for the `isPushed` state by adding padding to the body equal to the width of the element
   */
  var _useState = useState(null),
    _useState2 = _slicedToArray(_useState, 2),
    resizeRef = _useState2[0],
    setResizeRef = _useState2[1];
  var setRef = useCombinedRefs([setResizeRef, ref]);
  var _useResizeObserver = useResizeObserver(isPushed ? resizeRef : null, 'width'),
    width = _useResizeObserver.width;
  useEffect(function () {
    /**
     * Accomodate for the `isPushed` state by adding padding to the body equal to the width of the element
     */
    if (isPushed) {
      var paddingSide = side === 'left' ? 'paddingInlineStart' : 'paddingInlineEnd';
      document.body.style[paddingSide] = "".concat(width, "px");
      return function () {
        document.body.style[paddingSide] = '';
      };
    }
  }, [isPushed, side, width]);

  /**
   * This class doesn't actually do anything by EUI, but is nice to add for consumers (JIC)
   */
  useEffect(function () {
    document.body.classList.add('euiBody--hasFlyout');
    return function () {
      // Remove the hasFlyout class when the flyout is unmounted
      document.body.classList.remove('euiBody--hasFlyout');
    };
  }, []);

  /**
   * ESC key closes flyout (always?)
   */
  var onKeyDown = useCallback(function (event) {
    if (!isPushed && event.key === keys.ESCAPE) {
      event.preventDefault();
      onClose(event);
    }
  }, [onClose, isPushed]);

  /**
   * Set inline styles
   */
  var inlineStyles = useMemo(function () {
    var widthStyle = !isEuiFlyoutSizeNamed(size) && logicalStyle('width', size);
    var maxWidthStyle = typeof maxWidth !== 'boolean' && logicalStyle('max-width', maxWidth);
    return _objectSpread(_objectSpread(_objectSpread({}, style), widthStyle), maxWidthStyle);
  }, [style, maxWidth, size]);
  var styles = useEuiMemoizedStyles(euiFlyoutStyles);
  var cssStyles = [styles.euiFlyout, styles.paddingSizes[paddingSize], isEuiFlyoutSizeNamed(size) && styles[size], maxWidth === false && styles.noMaxWidth, isPushed ? styles.push.push : styles.overlay, isPushed && styles.push[side], isPushed && !pushAnimation && styles.push.noAnimation, styles[side]];
  var classes = classnames('euiFlyout', className);

  /*
   * If not disabled, automatically add fixed EuiHeaders as shards
   * to EuiFlyout focus traps, to prevent focus fighting
   */
  var flyoutToggle = useRef(document.activeElement);
  var _useState3 = useState([]),
    _useState4 = _slicedToArray(_useState3, 2),
    fixedHeaders = _useState4[0],
    setFixedHeaders = _useState4[1];
  useEffect(function () {
    if (includeFixedHeadersInFocusTrap) {
      var fixedHeaderEls = document.querySelectorAll('.euiHeader[data-fixed-header]');
      setFixedHeaders(Array.from(fixedHeaderEls));

      // Flyouts that are toggled from fixed headers do not have working
      // focus trap autoFocus, so we need to focus the flyout wrapper ourselves
      fixedHeaderEls.forEach(function (header) {
        if (header.contains(flyoutToggle.current)) {
          resizeRef === null || resizeRef === void 0 || resizeRef.focus();
        }
      });
    } else {
      // Clear existing headers if necessary, e.g. switching to `false`
      setFixedHeaders(function (headers) {
        return headers.length ? [] : headers;
      });
    }
  }, [includeFixedHeadersInFocusTrap, resizeRef]);
  var focusTrapProps = useMemo(function () {
    return _objectSpread(_objectSpread({}, _focusTrapProps), {}, {
      shards: [].concat(_toConsumableArray(fixedHeaders), _toConsumableArray((_focusTrapProps === null || _focusTrapProps === void 0 ? void 0 : _focusTrapProps.shards) || []))
    });
  }, [fixedHeaders, _focusTrapProps]);

  /*
   * Provide meaningful screen reader instructions/details
   */
  var hasOverlayMask = ownFocus && !isPushed;
  var descriptionId = useGeneratedHtmlId();
  var ariaDescribedBy = classnames(descriptionId, _ariaDescribedBy);
  var screenReaderDescription = useMemo(function () {
    return ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("p", {
      id: descriptionId
    }, hasOverlayMask ? ___EmotionJSX(EuiI18n, {
      token: "euiFlyout.screenReaderModalDialog",
      default: "You are in a modal dialog. Press Escape or tap/click outside the dialog on the shadowed overlay to close."
    }) : ___EmotionJSX(EuiI18n, {
      token: "euiFlyout.screenReaderNonModalDialog",
      default: "You are in a non-modal dialog. To close the dialog, press Escape."
    }), ' ', fixedHeaders.length > 0 && ___EmotionJSX(EuiI18n, {
      token: "euiFlyout.screenReaderFixedHeaders",
      default: "You can still continue tabbing through the page headers in addition to the dialog."
    })));
  }, [hasOverlayMask, descriptionId, fixedHeaders.length]);

  /*
   * Trap focus even when `ownFocus={false}`, otherwise closing
   * the flyout won't return focus to the originating button.
   *
   * Set `clickOutsideDisables={true}` when `ownFocus={false}`
   * to allow non-keyboard users the ability to interact with
   * elements outside the flyout.
   *
   * Set `onClickOutside={onClose}` when `ownFocus` and `type` are the defaults,
   * or if `outsideClickCloses={true}` to close on clicks that target
   * (both mousedown and mouseup) the overlay mask.
   */
  var onClickOutside = useCallback(function (event) {
    // Do not close the flyout for any external click
    if (outsideClickCloses === false) return undefined;
    if (hasOverlayMask) {
      // The overlay mask is present, so only clicks on the mask should close the flyout, regardless of outsideClickCloses
      if (event.target === maskRef.current) return onClose(event);
    } else {
      // No overlay mask is present, so any outside clicks should close the flyout
      if (outsideClickCloses === true) return onClose(event);
    }
    // Otherwise if ownFocus is false and outsideClickCloses is undefined, outside clicks should not close the flyout
    return undefined;
  }, [onClose, hasOverlayMask, outsideClickCloses]);
  return ___EmotionJSX(EuiFlyoutWrapper, {
    hasOverlayMask: hasOverlayMask,
    maskProps: _objectSpread(_objectSpread({}, maskProps), {}, {
      maskRef: useCombinedRefs([maskProps === null || maskProps === void 0 ? void 0 : maskProps.maskRef, maskRef])
    }),
    isPortalled: !isPushed
  }, ___EmotionJSX(EuiWindowEvent, {
    event: "keydown",
    handler: onKeyDown
  }), ___EmotionJSX(EuiFocusTrap, _extends({
    disabled: isPushed,
    scrollLock: hasOverlayMask,
    clickOutsideDisables: !ownFocus,
    onClickOutside: onClickOutside
  }, focusTrapProps), ___EmotionJSX(Element, _extends({
    className: classes,
    css: cssStyles,
    style: inlineStyles,
    ref: setRef
  }, rest, {
    role: !isPushed ? 'dialog' : rest.role,
    tabIndex: !isPushed ? 0 : rest.tabIndex,
    "aria-describedby": !isPushed ? ariaDescribedBy : _ariaDescribedBy,
    "data-autofocus": !isPushed || undefined
  }), !isPushed && screenReaderDescription, !hideCloseButton && onClose && ___EmotionJSX(EuiFlyoutCloseButton, _extends({}, closeButtonProps, {
    onClose: onClose,
    closeButtonPosition: closeButtonPosition,
    side: side
  })), children)));
}
// React.forwardRef interferes with the inferred element type
// Casting to ensure correct element prop type checking for `as`
// e.g., `href` is not on a `div`
);
// Recast to allow `displayName`
EuiFlyout.displayName = 'EuiFlyout';

/**
 * Light wrapper for conditionally rendering portals or overlay masks:
 *  - If ownFocus is set, wrap with an overlay and allow the user to click it to close it.
 *  - Otherwise still wrap within an EuiPortal so it appends to the bottom of the window.
 * Push flyouts have no overlay OR portal behavior.
 */
var EuiFlyoutWrapper = function EuiFlyoutWrapper(_ref2) {
  var children = _ref2.children,
    hasOverlayMask = _ref2.hasOverlayMask,
    maskProps = _ref2.maskProps,
    isPortalled = _ref2.isPortalled;
  if (hasOverlayMask) {
    return ___EmotionJSX(EuiOverlayMask, _extends({
      headerZindexLocation: "below"
    }, maskProps), children);
  } else if (isPortalled) {
    return ___EmotionJSX(EuiPortal, null, children);
  } else {
    return ___EmotionJSX(React.Fragment, null, children);
  }
};
EuiFlyoutWrapper.propTypes = {
  children: PropTypes.node.isRequired,
  hasOverlayMask: PropTypes.bool.isRequired,
  maskProps: PropTypes.shape({
    /**
       * ReactNode to render as this component's content
       */
    children: PropTypes.node,
    /**
       * Should the mask visually sit above or below the EuiHeader (controlled by z-index)
       */
    headerZindexLocation: PropTypes.oneOf(["above", "below"]),
    /**
       * React ref to be passed to the wrapping container
       */
    maskRef: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.any.isRequired])
  }).isRequired,
  isPortalled: PropTypes.bool.isRequired
};