var _excluded = ["children", "clickOutsideDisables", "disabled", "returnFocus", "noIsolation", "scrollLock", "gapMode"];
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import PropTypes from "prop-types";
import { FocusOn } from 'react-focus-on';
import { RemoveScrollBar } from 'react-remove-scroll-bar';
import { findElementBySelectorOrRef } from '../../services';
import { usePropsWithComponentDefaults } from '../provider/component_defaults';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiFocusTrap = function EuiFocusTrap(props) {
  var propsWithDefaults = usePropsWithComponentDefaults('EuiFocusTrap', props);
  return ___EmotionJSX(EuiFocusTrapClass, propsWithDefaults);
};
EuiFocusTrap.propTypes = {
  // For some reason, Storybook doesn't register these props if they're Pick<>'d
  className: PropTypes.string,
  css: PropTypes.any,
  style: PropTypes.any,
  /**
     * @default false
     */
  disabled: PropTypes.bool,
  /**
     * Whether `onClickOutside` should be called on mouseup instead of mousedown.
     * This flag can be used to prevent conflicts with outside toggle buttons by delaying the closing click callback.
     */
  closeOnMouseup: PropTypes.bool,
  /**
     * Clicking outside the trap area will disable the trap
     * @default false
     */
  clickOutsideDisables: PropTypes.bool,
  /**
     * Reference to element that will get focus when the trap is initiated
     */
  initialFocus: PropTypes.any,
  /**
     * if `scrollLock` is set to true, the body's scrollbar width will be preserved on lock
     * via the `gapMode` CSS property. Depending on your custom CSS, you may prefer to use
     * `margin` instead of `padding`.
     * @default padding
     */
  gapMode: PropTypes.oneOf(["padding", "margin"]),
  /**
     * Configures focus trapping between iframes.
     * By default, EuiFocusTrap allows focus to leave iframes and move to elements outside of it.
     * Set to `true` if you want focus to remain trapped within the iframe.
     * @default false
     */
  crossFrame: PropTypes.any,
  /**
     * @default false
     */
  scrollLock: PropTypes.any,
  /**
     * @default true
     */
  noIsolation: PropTypes.any,
  /**
     * @default true
     */
  returnFocus: PropTypes.any
};
var EuiFocusTrapClass = /*#__PURE__*/function (_Component) {
  function EuiFocusTrapClass() {
    var _this;
    _classCallCheck(this, EuiFocusTrapClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiFocusTrapClass, [].concat(args));
    _defineProperty(_this, "state", {
      hasBeenDisabledByClick: false
    });
    _defineProperty(_this, "lastInterceptedEvent", null);
    _defineProperty(_this, "preventFocusExit", false);
    // Programmatically sets focus on a nested DOM node; optional
    _defineProperty(_this, "setInitialFocus", function (initialFocus) {
      if (!initialFocus) return;
      var node = findElementBySelectorOrRef(initialFocus);
      if (!node) return;
      // `data-autofocus` is part of the 'react-focus-on' API
      node.setAttribute('data-autofocus', 'true');
    });
    _defineProperty(_this, "onMouseupOutside", function (e) {
      _this.removeMouseupListener();
      // Timeout gives precedence to the consumer to initiate close if it has toggle behavior.
      // Otherwise this event may occur first and the consumer toggle will reopen the flyout.
      setTimeout(function () {
        var _this$props$onClickOu, _this$props;
        return (_this$props$onClickOu = (_this$props = _this.props).onClickOutside) === null || _this$props$onClickOu === void 0 ? void 0 : _this$props$onClickOu.call(_this$props, e);
      });
    });
    _defineProperty(_this, "addMouseupListener", function () {
      document.addEventListener('mouseup', _this.onMouseupOutside);
      document.addEventListener('touchend', _this.onMouseupOutside);
    });
    _defineProperty(_this, "removeMouseupListener", function () {
      document.removeEventListener('mouseup', _this.onMouseupOutside);
      document.removeEventListener('touchend', _this.onMouseupOutside);
    });
    _defineProperty(_this, "handleOutsideClick", function (event) {
      var _this$props2 = _this.props,
        onClickOutside = _this$props2.onClickOutside,
        clickOutsideDisables = _this$props2.clickOutsideDisables,
        closeOnMouseup = _this$props2.closeOnMouseup;
      if (clickOutsideDisables) {
        _this.setState({
          hasBeenDisabledByClick: true
        });
      }
      if (onClickOutside) {
        closeOnMouseup ? _this.addMouseupListener() : onClickOutside(event);
      }
    });
    return _this;
  }
  _inherits(EuiFocusTrapClass, _Component);
  return _createClass(EuiFocusTrapClass, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.setInitialFocus(this.props.initialFocus);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.disabled === true && this.props.disabled === false) {
        this.setState({
          hasBeenDisabledByClick: false
        });
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.removeMouseupListener();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
        children = _this$props3.children,
        clickOutsideDisables = _this$props3.clickOutsideDisables,
        disabled = _this$props3.disabled,
        returnFocus = _this$props3.returnFocus,
        noIsolation = _this$props3.noIsolation,
        scrollLock = _this$props3.scrollLock,
        gapMode = _this$props3.gapMode,
        rest = _objectWithoutProperties(_this$props3, _excluded);
      var isDisabled = disabled || this.state.hasBeenDisabledByClick;
      var focusOnProps = _objectSpread(_objectSpread({
        returnFocus: returnFocus,
        noIsolation: noIsolation,
        enabled: !isDisabled
      }, rest), {}, {
        onClickOutside: this.handleOutsideClick,
        /**
         * `scrollLock` should always be unset on FocusOn, as it can prevent scrolling on
         * portals (i.e. popovers, comboboxes, dropdown menus, etc.) within modals & flyouts
         * @see https://github.com/theKashey/react-focus-on/issues/49
         */
        scrollLock: false
      });
      return ___EmotionJSX(FocusOn, focusOnProps, children, !isDisabled && scrollLock && ___EmotionJSX(RemoveScrollBar, {
        gapMode: gapMode
      }));
    }
  }]);
}(Component);
_defineProperty(EuiFocusTrapClass, "defaultProps", {
  clickOutsideDisables: false,
  disabled: false,
  returnFocus: true,
  noIsolation: true,
  scrollLock: false,
  crossFrame: false,
  gapMode: 'padding' // EUI defaults to padding because Kibana's body/layout CSS ignores `margin`
});
EuiFocusTrapClass.propTypes = {
  // For some reason, Storybook doesn't register these props if they're Pick<>'d
  className: PropTypes.string,
  css: PropTypes.any,
  style: PropTypes.any,
  /**
     * @default false
     */
  disabled: PropTypes.bool,
  /**
     * Whether `onClickOutside` should be called on mouseup instead of mousedown.
     * This flag can be used to prevent conflicts with outside toggle buttons by delaying the closing click callback.
     */
  closeOnMouseup: PropTypes.bool,
  /**
     * Clicking outside the trap area will disable the trap
     * @default false
     */
  clickOutsideDisables: PropTypes.bool,
  /**
     * Reference to element that will get focus when the trap is initiated
     */
  initialFocus: PropTypes.any,
  /**
     * if `scrollLock` is set to true, the body's scrollbar width will be preserved on lock
     * via the `gapMode` CSS property. Depending on your custom CSS, you may prefer to use
     * `margin` instead of `padding`.
     * @default padding
     */
  gapMode: PropTypes.oneOf(["padding", "margin"]),
  /**
     * Configures focus trapping between iframes.
     * By default, EuiFocusTrap allows focus to leave iframes and move to elements outside of it.
     * Set to `true` if you want focus to remain trapped within the iframe.
     * @default false
     */
  crossFrame: PropTypes.any,
  /**
     * @default false
     */
  scrollLock: PropTypes.any,
  /**
     * @default true
     */
  noIsolation: PropTypes.any,
  /**
     * @default true
     */
  returnFocus: PropTypes.any
};