var _excluded = ["className", "id", "checked", "label", "onChange", "type", "disabled", "readOnly", "indeterminate", "inputRef", "labelProps"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useCallback } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useCombinedRefs, useEuiMemoizedStyles } from '../../../services';
import { EuiIcon } from '../../icon';
import { euiCheckboxStyles } from './checkbox.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiCheckbox = function EuiCheckbox(_ref) {
  var className = _ref.className,
    id = _ref.id,
    _ref$checked = _ref.checked,
    checked = _ref$checked === void 0 ? false : _ref$checked,
    label = _ref.label,
    onChange = _ref.onChange,
    type = _ref.type,
    _ref$disabled = _ref.disabled,
    disabled = _ref$disabled === void 0 ? false : _ref$disabled,
    _ref$readOnly = _ref.readOnly,
    readOnly = _ref$readOnly === void 0 ? false : _ref$readOnly,
    _ref$indeterminate = _ref.indeterminate,
    indeterminate = _ref$indeterminate === void 0 ? false : _ref$indeterminate,
    inputRef = _ref.inputRef,
    labelProps = _ref.labelProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiCheckbox', className);
  var styles = useEuiMemoizedStyles(euiCheckboxStyles);
  var inputStyles = [styles.input.euiCheckbox__square, !!label && styles.input.hasLabel, disabled ? checked || indeterminate ? styles.input.disabled.selected : styles.input.disabled.unselected : checked || indeterminate ? styles.input.enabled.selected : styles.input.enabled.unselected, readOnly && styles.input.readOnly];
  var labelClasses = classNames('euiCheckbox__label', labelProps === null || labelProps === void 0 ? void 0 : labelProps.className);
  var labelStyles = [styles.label.euiCheckbox__label, disabled ? styles.label.disabled : styles.label.enabled, readOnly && styles.label.readOnly, labelProps === null || labelProps === void 0 ? void 0 : labelProps.css];
  var iconStyles = [styles.input.icon.euiCheckbox__icon, indeterminate ? styles.input.icon.indeterminate : styles.input.icon.check];

  // @see https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input/checkbox#indeterminate_state_checkboxes
  var setIndeterminateState = useCallback(function (input) {
    if (input) input.indeterminate = indeterminate;
  }, [indeterminate]);
  var refs = useCombinedRefs([inputRef, setIndeterminateState]);
  return ___EmotionJSX("div", {
    css: styles.euiCheckbox,
    className: classes
  }, ___EmotionJSX("div", {
    css: inputStyles,
    className: "euiCheckbox__square"
  }, ___EmotionJSX(EuiIcon, {
    css: iconStyles,
    type: indeterminate ? 'stopFilled' : checked ? 'check' : 'empty'
  }), ___EmotionJSX("input", _extends({
    css: styles.input.euiCheckbox__input,
    className: "euiCheckbox__input",
    type: "checkbox",
    id: id,
    checked: checked,
    onChange: onChange,
    disabled: disabled,
    readOnly: readOnly,
    ref: refs
  }, rest))), label && ___EmotionJSX("label", _extends({}, labelProps, {
    css: labelStyles,
    className: labelClasses,
    htmlFor: id
  }), label));
};
EuiCheckbox.propTypes = {
  id: PropTypes.string.isRequired,
  checked: PropTypes.bool,
  onChange: PropTypes.any.isRequired,
  // overriding to make it required
  inputRef: PropTypes.func,
  label: PropTypes.node,
  disabled: PropTypes.bool,
  indeterminate: PropTypes.bool,
  /**
     * Object of props passed to the <label/>
     */
  labelProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }),
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any
};