var _excluded = ["options", "idToSelectedMap", "onChange", "className", "disabled", "compressed", "legend"],
  _excluded2 = ["disabled", "className"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiFormFieldset } from '../form_fieldset';
import { EuiCheckbox } from './checkbox';
import { euiCheckboxGroupStyles } from './checkbox_group.styles';

// Must omit inherit `onChange` properties or else TS complains when applying to the EuiRadio
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiCheckboxGroup = function EuiCheckboxGroup(_ref) {
  var _ref$options = _ref.options,
    options = _ref$options === void 0 ? [] : _ref$options,
    _ref$idToSelectedMap = _ref.idToSelectedMap,
    idToSelectedMap = _ref$idToSelectedMap === void 0 ? {} : _ref$idToSelectedMap,
    onChange = _ref.onChange,
    className = _ref.className,
    disabled = _ref.disabled,
    compressed = _ref.compressed,
    legend = _ref.legend,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiCheckboxGroup', className);
  var styles = useEuiMemoizedStyles(euiCheckboxGroupStyles);
  var cssStyles = [styles.euiCheckboxGroup, compressed ? styles.compressed : styles.uncompressed];
  var checkboxes = options.map(function (option, index) {
    var isOptionDisabled = option.disabled,
      optionClass = option.className,
      optionRest = _objectWithoutProperties(option, _excluded2);
    return ___EmotionJSX(EuiCheckbox, _extends({
      className: classNames('euiCheckboxGroup__item', optionClass),
      key: index,
      checked: idToSelectedMap[option.id],
      disabled: disabled || isOptionDisabled,
      onChange: onChange.bind(null, option.id)
    }, optionRest));
  });
  if (!!legend) {
    // Be sure to pass down the compressed option to the legend
    legend.compressed = compressed;
    return ___EmotionJSX(EuiFormFieldset, _extends({
      css: cssStyles,
      className: classes,
      legend: legend
    }, rest), checkboxes);
  }
  return ___EmotionJSX("div", _extends({
    css: cssStyles,
    className: classes
  }, rest), checkboxes);
};
EuiCheckboxGroup.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  options: PropTypes.arrayOf(PropTypes.shape({
    id: PropTypes.string.isRequired
  }).isRequired).isRequired,
  idToSelectedMap: PropTypes.shape({}).isRequired,
  onChange: PropTypes.func.isRequired,
  /**
     * Tightens up the spacing between checkbox rows
     */
  compressed: PropTypes.bool,
  /**
     * Passed down to all child `EuiCheckbox`es
     */
  disabled: PropTypes.bool,
  /**
     * If the individual labels for each radio do not provide a sufficient description, add a legend.
     * Wraps the group in a `EuiFormFieldset` which adds an `EuiLegend` for titling the whole group.
     * Accepts an `EuiFormLegendProps` shape.
     */
  legend: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any,
    /**
         * ReactNode to render as this component's content
         */
    children: PropTypes.node.isRequired,
    /**
         * For a hidden legend that is still visible to the screen reader, set to 'hidden'
         */
    display: PropTypes.oneOf(["hidden", "visible"]),
    compressed: PropTypes.bool
  })
};