/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiFormControlStyles } from '../form.styles';
export var euiFieldTextStyles = function euiFieldTextStyles(euiThemeContext) {
  var formStyles = euiFormControlStyles(euiThemeContext);
  return {
    euiFieldText: /*#__PURE__*/css(formStyles.shared, " &:invalid{", formStyles.invalid, ";}&:focus{", formStyles.focus, ";}&:disabled{", formStyles.disabled, ";}&[readOnly]{", formStyles.readOnly, ";}&:autofill{", formStyles.autoFill, ";};label:euiFieldText;"),
    // Skip the css() on the default height to avoid generating a className
    uncompressed: formStyles.uncompressed,
    compressed: /*#__PURE__*/css(formStyles.compressed, ";label:compressed;"),
    // Skip the css() on the default width to avoid generating a className
    formWidth: formStyles.formWidth,
    fullWidth: /*#__PURE__*/css(formStyles.fullWidth, ";label:fullWidth;"),
    // Layout modifiers
    inGroup: /*#__PURE__*/css(formStyles.inGroup, ";label:inGroup;"),
    controlOnly: /*#__PURE__*/css(".euiFormControlLayout--group &{", formStyles.inGroup, ";};label:controlOnly;")
  };
};