var _excluded = ["stylesMemoizer", "id", "name", "initialPromptText", "className", "disabled", "compressed", "onChange", "isInvalid", "fullWidth", "isLoading", "display"];
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { withEuiStylesMemoizer, htmlIdGenerator } from '../../../services';
import { EuiButtonEmpty } from '../../button';
import { EuiProgress } from '../../progress';
import { EuiIcon } from '../../icon';
import { EuiI18n } from '../../i18n';
import { EuiLoadingSpinner } from '../../loading';
import { FormContext } from '../eui_form_context';
import { EuiValidatableControl } from '../validatable_control';
import { EuiFormControlLayoutClearButton } from '../form_control_layout/form_control_layout_clear_button';
import { euiFilePickerStyles } from './file_picker.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiFilePickerClass = /*#__PURE__*/function (_Component) {
  function EuiFilePickerClass() {
    var _this;
    _classCallCheck(this, EuiFilePickerClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiFilePickerClass, [].concat(args));
    _defineProperty(_this, "state", {
      promptText: null,
      isHoveringDrop: false
    });
    _defineProperty(_this, "fileInput", null);
    _defineProperty(_this, "generatedId", htmlIdGenerator()());
    _defineProperty(_this, "handleChange", function () {
      if (!_this.fileInput) return;
      if (_this.fileInput.files && _this.fileInput.files.length > 1) {
        _this.setState({
          promptText: ___EmotionJSX(EuiI18n, {
            token: "euiFilePicker.filesSelected",
            default: "{fileCount} files selected",
            values: {
              fileCount: _this.fileInput.files.length
            }
          })
        });
      } else if (_this.fileInput.files && _this.fileInput.files.length === 0) {
        _this.setState({
          promptText: null
        });
      } else {
        _this.setState({
          promptText: _this.fileInput.value.split('\\').pop()
        });
      }
      var onChange = _this.props.onChange;
      if (onChange) {
        onChange(_this.fileInput.files);
      }
    });
    _defineProperty(_this, "removeFiles", function (e) {
      if (e) {
        e.stopPropagation();
        e.preventDefault();
      }
      if (!_this.fileInput) return;
      _this.fileInput.value = '';
      _this.handleChange();
    });
    _defineProperty(_this, "showDrop", function () {
      if (!_this.props.disabled) {
        _this.setState({
          isHoveringDrop: true
        });
      }
    });
    _defineProperty(_this, "hideDrop", function () {
      _this.setState({
        isHoveringDrop: false
      });
    });
    return _this;
  }
  _inherits(EuiFilePickerClass, _Component);
  return _createClass(EuiFilePickerClass, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var _ref = this.context,
        defaultFullWidth = _ref.defaultFullWidth;
      return ___EmotionJSX(EuiI18n, {
        token: "euiFilePicker.removeSelectedAriaLabel",
        default: "Remove selected files"
      }, function (removeSelectedAriaLabel) {
        var _this2$props = _this2.props,
          stylesMemoizer = _this2$props.stylesMemoizer,
          id = _this2$props.id,
          name = _this2$props.name,
          initialPromptText = _this2$props.initialPromptText,
          className = _this2$props.className,
          disabled = _this2$props.disabled,
          compressed = _this2$props.compressed,
          onChange = _this2$props.onChange,
          isInvalid = _this2$props.isInvalid,
          _this2$props$fullWidt = _this2$props.fullWidth,
          fullWidth = _this2$props$fullWidt === void 0 ? defaultFullWidth : _this2$props$fullWidt,
          isLoading = _this2$props.isLoading,
          display = _this2$props.display,
          rest = _objectWithoutProperties(_this2$props, _excluded);
        var promptId = "".concat(id || _this2.generatedId, "-filePicker__prompt");
        var isOverridingInitialPrompt = _this2.state.promptText != null;
        var normalFormControl = display === 'default';
        var classes = classNames('euiFilePicker', {
          'euiFilePicker-isDroppingFile': _this2.state.isHoveringDrop,
          'euiFilePicker-isInvalid': isInvalid,
          'euiFilePicker-isLoading': isLoading,
          'euiFilePicker-hasFiles': isOverridingInitialPrompt
        }, className);
        var styles = stylesMemoizer(euiFilePickerStyles);
        var cssStyles = [styles.euiFilePicker, fullWidth ? styles.fullWidth : styles.formWidth, _this2.state.isHoveringDrop && styles.isDroppingFile, isInvalid && !disabled && styles.invalid, isOverridingInitialPrompt && !disabled && styles.hasFiles, isLoading && styles.loading];
        var inputStyles = [styles.input.euiFilePicker__input, !normalFormControl && !disabled && styles.input.largeInteractive];
        var promptStyles = [styles.euiFilePicker__prompt, disabled && styles.disabled].concat(_toConsumableArray(normalFormControl ? [compressed ? styles.compressed : styles.uncompressed] : [styles.large.large, compressed ? styles.large.compressed : styles.large.uncompressed]));
        var iconStyles = [styles.icon.euiFilePicker__icon].concat(_toConsumableArray(normalFormControl ? [styles.icon.normal, compressed ? styles.icon.compresssed : styles.icon.uncompressed] : [styles.icon.large]));
        var rightIconStyles = normalFormControl ? [styles.rightIcon.euiFilePicker__rightIcon, compressed ? styles.rightIcon.compressed : styles.rightIcon.uncompressed] : undefined;
        var clearButton;
        if (isLoading && normalFormControl) {
          // Override clear button with loading spinner if it is in loading state
          clearButton = ___EmotionJSX(EuiLoadingSpinner, {
            css: rightIconStyles,
            className: "euiFilePicker__loadingSpinner",
            size: compressed ? 's' : 'm'
          });
        } else if (isOverridingInitialPrompt && !disabled) {
          if (normalFormControl) {
            clearButton = ___EmotionJSX(EuiFormControlLayoutClearButton, {
              "aria-label": removeSelectedAriaLabel,
              css: [styles.euiFilePicker__clearButton, rightIconStyles, ";label:clearButton;"],
              className: "euiFilePicker__clearButton",
              onClick: _this2.removeFiles,
              size: compressed ? 's' : 'm'
            });
          } else {
            clearButton = ___EmotionJSX(EuiButtonEmpty, {
              "aria-label": removeSelectedAriaLabel,
              css: styles.euiFilePicker__clearButton,
              className: "euiFilePicker__clearButton",
              size: "xs",
              onClick: _this2.removeFiles
            }, ___EmotionJSX(EuiI18n, {
              token: "euiFilePicker.removeSelected",
              default: "Remove"
            }));
          }
        } else {
          clearButton = null;
        }
        var loader = !normalFormControl && isLoading && ___EmotionJSX(EuiProgress, {
          size: "xs",
          color: "accent",
          position: "absolute"
        });
        return ___EmotionJSX("div", {
          css: cssStyles,
          className: classes
        }, ___EmotionJSX(EuiValidatableControl, {
          isInvalid: isInvalid
        }, ___EmotionJSX("input", _extends({
          type: "file",
          id: id,
          name: name,
          css: inputStyles,
          className: "euiFilePicker__input",
          onChange: _this2.handleChange,
          ref: function ref(input) {
            _this2.fileInput = input;
          },
          onDragOver: _this2.showDrop,
          onDragLeave: _this2.hideDrop,
          onDrop: _this2.hideDrop,
          disabled: disabled,
          "aria-describedby": promptId
        }, rest))), ___EmotionJSX("div", {
          css: promptStyles,
          className: "euiFilePicker__prompt",
          id: promptId
        }, ___EmotionJSX(EuiIcon, {
          css: iconStyles,
          className: "euiFilePicker__icon",
          color: isInvalid ? 'danger' : disabled ? 'subdued' : 'primary',
          type: isInvalid ? 'alert' : 'importAction',
          size: normalFormControl ? 'm' : 'l',
          "aria-hidden": "true"
        }), ___EmotionJSX("span", {
          className: "euiFilePicker__promptText"
        }, _this2.state.promptText || initialPromptText), clearButton, loader));
      });
    }
  }]);
}(Component);
_defineProperty(EuiFilePickerClass, "contextType", FormContext);
_defineProperty(EuiFilePickerClass, "defaultProps", {
  initialPromptText: ___EmotionJSX(EuiI18n, {
    token: "euiFilePicker.promptText",
    default: "Select or drag and drop a file"
  }),
  compressed: false,
  display: 'large'
});
EuiFilePickerClass.propTypes = {
  id: PropTypes.string,
  name: PropTypes.string,
  className: PropTypes.string,
  /**
     * The content that appears in the dropzone if no file is attached
     * @default 'Select or drag and drop a file'
     */
  initialPromptText: PropTypes.node,
  /**
     * Use as a callback to access the HTML FileList API
     */
  onChange: PropTypes.func,
  /**
     * Reduces the size to a typical (compressed) input
     * @default false
     */
  compressed: PropTypes.bool,
  /**
     * Size or type of display;
     * `default` for normal height, similar to other controls;
     * `large` for taller size
     * @default large
     */
  display: PropTypes.oneOf(["default", "large"]),
  /**
     * Expand to fill 100% of the parent.
     * Defaults to `fullWidth` prop of `<EuiForm>`.
     * @default false
     */
  fullWidth: PropTypes.bool,
  isInvalid: PropTypes.bool,
  isLoading: PropTypes.bool,
  disabled: PropTypes.bool,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any
};
export var EuiFilePicker = withEuiStylesMemoizer(EuiFilePickerClass);