var _excluded = ["children", "className", "isInvalid", "error", "component", "invalidCallout", "fullWidth"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useCallback, useMemo, forwardRef } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { EuiCallOut } from '../call_out';
import { EuiI18n } from '../i18n';
import { EuiSpacer } from '../spacer';
import { FormContext } from './eui_form_context';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiForm = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var children = _ref.children,
    className = _ref.className,
    isInvalid = _ref.isInvalid,
    error = _ref.error,
    _ref$component = _ref.component,
    component = _ref$component === void 0 ? 'div' : _ref$component,
    _ref$invalidCallout = _ref.invalidCallout,
    invalidCallout = _ref$invalidCallout === void 0 ? 'above' : _ref$invalidCallout,
    fullWidth = _ref.fullWidth,
    rest = _objectWithoutProperties(_ref, _excluded);
  var formContext = useMemo(function () {
    return {
      defaultFullWidth: fullWidth !== null && fullWidth !== void 0 ? fullWidth : false
    };
  }, [fullWidth]);
  var handleFocus = useCallback(function (node) {
    node === null || node === void 0 || node.focus();
  }, []);
  var classes = classNames('euiForm', className);
  var optionalErrors = null;
  if (error) {
    var errorTexts = Array.isArray(error) ? error : [error];
    optionalErrors = ___EmotionJSX("ul", null, errorTexts.map(function (error, index) {
      return ___EmotionJSX("li", {
        className: "euiForm__error",
        key: index
      }, error);
    }));
  }
  var optionalErrorAlert;
  if (isInvalid && invalidCallout === 'above') {
    optionalErrorAlert = ___EmotionJSX(EuiI18n, {
      token: "euiForm.addressFormErrors",
      default: "Please address the highlighted errors."
    }, function (addressFormErrors) {
      return ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiCallOut, {
        tabIndex: -1,
        ref: handleFocus,
        className: "euiForm__errors",
        title: addressFormErrors,
        color: "danger",
        role: "alert",
        "aria-live": "assertive"
      }, optionalErrors), ___EmotionJSX(EuiSpacer, {
        size: "m"
      }));
    });
  }
  var Element = component;
  return ___EmotionJSX(Element
  // @ts-expect-error Element is a <div> or <form>, but TypeScript wants to support both
  , _extends({
    ref: ref,
    className: classes
  }, rest), ___EmotionJSX(FormContext.Provider, {
    value: formContext
  }, optionalErrorAlert, children));
});
EuiForm.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
       * Which HTML element to render `div` or `form`
       */
  component: PropTypes.oneOfType([PropTypes.oneOfType([PropTypes.oneOf(["form"]).isRequired, PropTypes.oneOf(["div"])]), PropTypes.oneOf(["form", "div"])]),
  isInvalid: PropTypes.bool,
  error: PropTypes.oneOfType([PropTypes.node.isRequired, PropTypes.arrayOf(PropTypes.node.isRequired).isRequired]),
  /**
       * Where to display the callout with the list of errors
       */
  invalidCallout: PropTypes.oneOf(["above", "none"]),
  /**
       * When set to `true`, all the rows/controls in this form will
       * default to taking up 100% of the width of their continer. You
       * can specify `fullWidth={false}` on individual rows/controls to
       * disable this behavior for specific components.
       * @default false
       */
  fullWidth: PropTypes.bool
};
EuiForm.displayName = 'EuiForm';