function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiTextTruncate, logicalCSS, mathWithUnits } from '../../../global_styling';
import { euiFormVariables } from '../form.styles';
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1w10n1m-inGroup",
  styles: "flex-grow:1;overflow:hidden;label:inGroup;"
} : {
  name: "1w10n1m-inGroup",
  styles: "flex-grow:1;overflow:hidden;label:inGroup;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "1lbfa6m-euiFormControlLayout__childrenWrapper",
  styles: "position:relative;label:euiFormControlLayout__childrenWrapper;"
} : {
  name: "1lbfa6m-euiFormControlLayout__childrenWrapper",
  styles: "position:relative;label:euiFormControlLayout__childrenWrapper;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiFormControlLayoutStyles = function euiFormControlLayoutStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var form = euiFormVariables(euiThemeContext);
  return {
    euiFormControlLayout: /*#__PURE__*/css(";label:euiFormControlLayout;"),
    // Skip the css`` on the default height to avoid generating a className
    uncompressed: "\n      ".concat(logicalCSS('height', form.controlHeight), "\n    "),
    compressed: /*#__PURE__*/css(logicalCSS('height', form.controlCompressedHeight), ";;label:compressed;"),
    // Skip the css`` on the default width to avoid generating a className
    formWidth: "\n      ".concat(logicalCSS('max-width', form.maxWidth), "\n      ").concat(logicalCSS('width', '100%'), "\n    "),
    fullWidth: /*#__PURE__*/css(logicalCSS('max-width', '100%'), " ", logicalCSS('width', '100%'), ";;label:fullWidth;"),
    group: {
      group: /*#__PURE__*/css("display:flex;align-items:stretch;border:", euiTheme.border.width.thin, " solid ", form.borderColor, ";background-color:", form.backgroundColor, ";overflow:hidden;>*{", logicalCSS('height', '100%'), ";};label:group;"),
      // Skipping css`` to avoid repeated compressed/uncompressed classNames
      uncompressed: "\n        border-radius: ".concat(form.controlBorderRadius, ";\n      "),
      compressed: "\n        border-radius: ".concat(form.controlCompressedBorderRadius, ";\n      ")
    },
    children: {
      euiFormControlLayout__childrenWrapper: _ref2,
      inGroup: _ref,
      prependOnly: /*#__PURE__*/css(logicalCSS('border-top-right-radius', 'inherit'), " ", logicalCSS('border-bottom-right-radius', 'inherit'), ";;label:prependOnly;"),
      appendOnly: /*#__PURE__*/css(logicalCSS('border-top-left-radius', 'inherit'), " ", logicalCSS('border-bottom-left-radius', 'inherit'), ";;label:appendOnly;")
    }
  };
};
export var euiFormControlLayoutSideNodeStyles = function euiFormControlLayoutSideNodeStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var form = euiFormVariables(euiThemeContext);
  var uncompressedHeight = mathWithUnits([form.controlHeight, euiTheme.border.width.thin], function (x, y) {
    return x - y * 2;
  });
  var compressedHeight = mathWithUnits([form.controlCompressedHeight, euiTheme.border.width.thin], function (x, y) {
    return x - y * 2;
  });
  var buttons = '*:is(.euiButton, .euiButtonEmpty, .euiButtonIcon)';
  var text = '*:is(.euiFormLabel, .euiText)';
  return {
    euiFormControlLayout__side: /*#__PURE__*/css(logicalCSS('height', '100%'), " ", euiTextTruncate('50%'), " flex-shrink:0;display:flex;align-items:center;gap:", euiTheme.size.xs, ";background-color:", form.appendPrependBackground, ";", buttons, "{transform:none!important;&:focus-visible{outline-offset:-", euiTheme.focus.width, ";}}", text, "{cursor:default;overflow:hidden;text-overflow:ellipsis;}&:not(:has(> ", buttons, ":first-child, > *:first-child > ", buttons, ")){", logicalCSS('padding-left', euiTheme.size.s), ";}&:not(:has(> ", buttons, ":last-child, > *:last-child > ", buttons, ")){", logicalCSS('padding-right', euiTheme.size.s), ";};label:euiFormControlLayout__side;"),
    append: /*#__PURE__*/css(";label:append;"),
    prepend: /*#__PURE__*/css(";label:prepend;"),
    uncompressed: "\n      ".concat(text, " {\n        ").concat(logicalCSS('padding-horizontal', euiTheme.size.xs), "\n        line-height: ").concat(uncompressedHeight, ";\n      }\n\n      ").concat(buttons, " {\n        ").concat(logicalCSS('height', uncompressedHeight), "\n      }\n\n      .euiButtonIcon {\n        flex-shrink: 0;\n        ").concat(logicalCSS('width', euiTheme.size.xl), "\n      }\n    "),
    compressed: /*#__PURE__*/css(text, "{", logicalCSS('padding-horizontal', euiTheme.size.xxs), " line-height:", compressedHeight, ";}", buttons, "{", logicalCSS('height', compressedHeight), ";}.euiButtonIcon{flex-shrink:0;", logicalCSS('width', euiTheme.size.xl), ";};label:compressed;")
  };
};