var _excluded = ["className", "onClick", "size"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiIcon } from '../../icon';
import { useEuiI18n } from '../../i18n';
import { EuiFormControlLayoutClearButtonStyles } from './form_control_layout_clear_button.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiFormControlLayoutClearButton = function EuiFormControlLayoutClearButton(_ref) {
  var className = _ref.className,
    onClick = _ref.onClick,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiFormControlLayoutClearButton', className);
  var styles = useEuiMemoizedStyles(EuiFormControlLayoutClearButtonStyles);
  var iconStyles = [styles.euiFormControlLayoutClearButton__icon, styles.size[size]];
  var ariaLabel = useEuiI18n('euiFormControlLayoutClearButton.label', 'Clear input');
  return ___EmotionJSX("button", _extends({
    type: "button",
    css: styles.euiFormControlLayoutClearButton,
    className: classes,
    onClick: onClick,
    "aria-label": ariaLabel
  }, rest), ___EmotionJSX(EuiIcon, {
    css: iconStyles,
    className: "euiFormControlLayoutClearButton__icon",
    type: "cross",
    size: size
  }));
};
EuiFormControlLayoutClearButton.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  size: PropTypes.oneOf(["s", "m"])
};