/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
export var EuiFormControlLayoutClearButtonStyles = function EuiFormControlLayoutClearButtonStyles(_ref) {
  var euiTheme = _ref.euiTheme,
    colorMode = _ref.colorMode;
  var backgroundColor = colorMode === 'DARK' ? euiTheme.colors.darkShade : euiTheme.colors.mediumShade;
  return {
    euiFormControlLayoutClearButton: /*#__PURE__*/css("pointer-events:all;background-color:", backgroundColor, ";border-radius:50%;line-height:0;&:disabled{cursor:not-allowed;background-color:", euiTheme.colors.disabled, ";};label:euiFormControlLayoutClearButton;"),
    euiFormControlLayoutClearButton__icon: /*#__PURE__*/css("transform:scale(0.5);fill:", euiTheme.colors.emptyShade, ";stroke:", euiTheme.colors.emptyShade, ";;label:euiFormControlLayoutClearButton__icon;"),
    size: {
      s: /*#__PURE__*/css("stroke-width:", euiTheme.size.xs, ";;label:s;"),
      m: /*#__PURE__*/css("stroke-width:", euiTheme.size.xxs, ";;label:m;")
    }
  };
};