function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["startControl", "endControl", "delimiter", "className", "fullWidth"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles, cloneElementWithCss } from '../../../services';
import { useEuiI18n } from '../../i18n';
import { EuiIcon } from '../../icon';
import { EuiText } from '../../text';
import { FormContext, useFormContext } from '../eui_form_context';
import { EuiFormControlLayout } from './form_control_layout';
import { euiFormControlLayoutDelimitedStyles, euiFormControlLayoutDelimited__delimiter, euiFormControlLayoutDelimited__input } from './form_control_layout_delimited.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiFormControlLayoutDelimited = function EuiFormControlLayoutDelimited(_ref) {
  var _rest$wrapperProps;
  var startControl = _ref.startControl,
    endControl = _ref.endControl,
    delimiter = _ref.delimiter,
    className = _ref.className,
    _fullWidth = _ref.fullWidth,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useFormContext = useFormContext(),
    defaultFullWidth = _useFormContext.defaultFullWidth;
  var fullWidth = _fullWidth !== null && _fullWidth !== void 0 ? _fullWidth : defaultFullWidth;
  var isInvalid = rest.isInvalid,
    isDisabled = rest.isDisabled,
    readOnly = rest.readOnly;
  var showInvalidState = isInvalid && !isDisabled && !readOnly;
  var classes = classNames('euiFormControlLayoutDelimited', className, {
    'euiFormControlLayoutDelimited--isInvalid': showInvalidState
  });
  var styles = useEuiMemoizedStyles(euiFormControlLayoutDelimitedStyles);
  var cssStyles = [styles.delimited, rest.isDisabled && styles.disabled, rest.readOnly && styles.readOnly];
  var wrapperStyles = [styles.childrenWrapper.delimited, showInvalidState && styles.childrenWrapper.invalid, (_rest$wrapperProps = rest.wrapperProps) === null || _rest$wrapperProps === void 0 ? void 0 : _rest$wrapperProps.css];
  return ___EmotionJSX(EuiFormControlLayout, _extends({
    isDelimited: true,
    css: cssStyles,
    className: classes,
    iconsPosition: "static",
    fullWidth: fullWidth
  }, rest, {
    wrapperProps: _objectSpread(_objectSpread({}, rest.wrapperProps), {}, {
      css: wrapperStyles
    })
  }), ___EmotionJSX(FormContext.Provider, {
    value: {
      defaultFullWidth: fullWidth
    }
  }, addClassesToControl(startControl), ___EmotionJSX(EuiFormControlDelimiter, {
    delimiter: delimiter,
    isInvalid: showInvalidState
  }), addClassesToControl(endControl)));
};
EuiFormControlLayoutDelimited.propTypes = {
  /**
       * Left side control
       */
  startControl: PropTypes.element.isRequired,
  /**
       * Right side control
       */
  endControl: PropTypes.element.isRequired,
  /**
       * The center content. Accepts a string to be wrapped in a subdued EuiText
       * or a single ReactElement
       */
  delimiter: PropTypes.node,
  className: PropTypes.string
};
var addClassesToControl = function addClassesToControl(control) {
  return cloneElementWithCss(control, {
    css: euiFormControlLayoutDelimited__input,
    className: classNames(control.props.className, 'euiFormControlLayoutDelimited__input')
  }, 'before');
};
var EuiFormControlDelimiter = function EuiFormControlDelimiter(_ref2) {
  var delimiter = _ref2.delimiter,
    isInvalid = _ref2.isInvalid;
  var defaultAriaLabel = useEuiI18n('euiFormControlLayoutDelimited.delimiterLabel', 'to');
  return ___EmotionJSX(EuiText, {
    css: euiFormControlLayoutDelimited__delimiter,
    className: "euiFormControlLayoutDelimited__delimiter",
    size: "s",
    color: isInvalid ? 'danger' : 'subdued'
  }, delimiter !== null && delimiter !== void 0 ? delimiter : ___EmotionJSX(EuiIcon, {
    type: "sortRight",
    "aria-label": defaultAriaLabel
  }));
};