var _excluded = ["fontWeight"];
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { serializeStyles } from '@emotion/serialize';
import { euiCanAnimate, euiTextBreakWord } from '../../../global_styling';
import { euiTitle } from '../../title/title.styles';
export var euiFormLabel = function euiFormLabel(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  // Exclude the fontWeight from the title, since we're setting our own later
  var _euiTitle = euiTitle(euiThemeContext, 'xxxs'),
    _ = _euiTitle.fontWeight,
    _titleStyles = _objectWithoutProperties(_euiTitle, _excluded);
  // Since we're not returning a css`` string (to avoid generating an extra Emotion
  // className), we need to manually serialize the style object into a string
  var titleStyles = serializeStyles([_titleStyles]).styles;
  return "\n    ".concat(titleStyles, "\n    font-weight: ").concat(euiTheme.font.weight.semiBold, ";\n    ").concat(euiTextBreakWord(), "\n  ");
};
export var euiFormLabelStyles = function euiFormLabelStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiFormLabel: /*#__PURE__*/css(euiFormLabel(euiThemeContext), " display:inline-block;", euiCanAnimate, "{transition:color ", euiTheme.animation.fast, " ", euiTheme.animation.resistance, ";};label:euiFormLabel;"),
    // Skip css`` to avoid generating an extra Emotion className
    // Use :where to reduce specificity & make the CSS easier to override by prepend/append nodes
    notDisabled: "\n      &:where([for]) {\n        cursor: pointer;\n      }\n    ",
    invalid: /*#__PURE__*/css("color:", euiTheme.colors.danger, ";;label:invalid;"),
    // Focused state should override invalid state
    focused: /*#__PURE__*/css("color:", euiTheme.colors.primary, ";;label:focused;")
  };
};