var _excluded = ["className", "children", "helpText", "isInvalid", "error", "label", "labelType", "labelAppend", "hasEmptyLabelSpace", "fullWidth", "describedByIds", "display", "hasChildLabel", "id", "isDisabled"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { cloneElement, Children, useState, useCallback, useMemo } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useGeneratedHtmlId, useEuiMemoizedStyles } from '../../../services';
import { EuiSpacer } from '../../spacer';
import { EuiFormHelpText } from '../form_help_text';
import { EuiFormErrorText } from '../form_error_text';
import { EuiFormLabel } from '../form_label';
import { useFormContext } from '../eui_form_context';
import { euiFormRowStyles } from './form_row.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var DISPLAYS = ['row', 'columnCompressed', 'center', 'centerCompressed',
/**
 * This currently does not affect styles/appearances
 * in EUI's present primary theme, but may in the future.
 */
'rowCompressed'];
export var EuiFormRow = function EuiFormRow(_ref) {
  var className = _ref.className,
    children = _ref.children,
    helpText = _ref.helpText,
    isInvalid = _ref.isInvalid,
    error = _ref.error,
    label = _ref.label,
    _ref$labelType = _ref.labelType,
    labelType = _ref$labelType === void 0 ? 'label' : _ref$labelType,
    labelAppend = _ref.labelAppend,
    _ref$hasEmptyLabelSpa = _ref.hasEmptyLabelSpace,
    hasEmptyLabelSpace = _ref$hasEmptyLabelSpa === void 0 ? false : _ref$hasEmptyLabelSpa,
    _fullWidth = _ref.fullWidth,
    describedByIds = _ref.describedByIds,
    _ref$display = _ref.display,
    display = _ref$display === void 0 ? 'row' : _ref$display,
    _ref$hasChildLabel = _ref.hasChildLabel,
    hasChildLabel = _ref$hasChildLabel === void 0 ? true : _ref$hasChildLabel,
    propsId = _ref.id,
    isDisabled = _ref.isDisabled,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useFormContext = useFormContext(),
    defaultFullWidth = _useFormContext.defaultFullWidth;
  var fullWidth = _fullWidth !== null && _fullWidth !== void 0 ? _fullWidth : defaultFullWidth;
  var id = useGeneratedHtmlId({
    conditionalId: propsId
  });
  var hasLabel = label || labelAppend;
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isFocused = _useState2[0],
    setIsFocused = _useState2[1];
  var onFocusWithin = useCallback(function () {
    return setIsFocused(true);
  }, []);
  var onBlurWithin = useCallback(function () {
    return setIsFocused(false);
  }, []);
  var classes = classNames('euiFormRow', {
    'euiFormRow--hasEmptyLabelSpace': hasEmptyLabelSpace,
    'euiFormRow--hasLabel': hasLabel
  }, className);
  var styles = useEuiMemoizedStyles(euiFormRowStyles);
  var cssStyles = [styles.euiFormRow, fullWidth ? styles.fullWidth : styles.formWidth, styles[display]];
  var optionalHelpTexts = useMemo(function () {
    if (!helpText) return;
    var helpTexts = Array.isArray(helpText) ? helpText : [helpText];
    return helpTexts.map(function (helpText, i) {
      var key = typeof helpText === 'string' ? helpText : i;
      return ___EmotionJSX(EuiFormHelpText, {
        key: key,
        id: "".concat(id, "-help-").concat(i),
        className: "euiFormRow__text"
      }, helpText);
    });
  }, [helpText, id]);
  var optionalErrors = useMemo(function () {
    if (!(error && isInvalid)) return;
    var errorTexts = Array.isArray(error) ? error : [error];
    return errorTexts.map(function (error, i) {
      var key = typeof error === 'string' ? error : i;
      return ___EmotionJSX(EuiFormErrorText, {
        key: key,
        id: "".concat(id, "-error-").concat(i),
        className: "euiFormRow__text"
      }, error);
    });
  }, [error, isInvalid, id]);
  var ariaDescribedBy = useMemo(function () {
    var describingIds = _toConsumableArray(describedByIds || []);
    if (optionalHelpTexts !== null && optionalHelpTexts !== void 0 && optionalHelpTexts.length) {
      optionalHelpTexts.forEach(function (optionalHelpText) {
        return describingIds.push(optionalHelpText.props.id);
      });
    }
    if (optionalErrors !== null && optionalErrors !== void 0 && optionalErrors.length) {
      optionalErrors.forEach(function (error) {
        return describingIds.push(error.props.id);
      });
    }
    if (describingIds.length) {
      return describingIds.join(' ');
    }
  }, [describedByIds, optionalHelpTexts, optionalErrors]);
  var field = useMemo(function () {
    var _ref2, _child$props$disabled;
    var child = Children.only(children);
    return /*#__PURE__*/cloneElement(child, {
      id: id,
      // Allow the child's disabled or isDisabled prop to supercede the `isDisabled`
      disabled: (_ref2 = (_child$props$disabled = child.props.disabled) !== null && _child$props$disabled !== void 0 ? _child$props$disabled : child.props.isDisabled) !== null && _ref2 !== void 0 ? _ref2 : isDisabled,
      'aria-describedby': ariaDescribedBy
    });
  }, [children, id, isDisabled, ariaDescribedBy]);
  var Element = labelType === 'legend' ? 'fieldset' : 'div';
  return ___EmotionJSX(Element, _extends({
    css: cssStyles,
    className: classes,
    id: "".concat(id, "-row")
  }, rest), hasLabel ? ___EmotionJSX("div", {
    className: "euiFormRow__labelWrapper"
  }, ___EmotionJSX(EuiFormLabel, _extends({
    className: "euiFormRow__label",
    "aria-invalid": isInvalid,
    isInvalid: isInvalid,
    isDisabled: isDisabled,
    isFocused: isFocused && !isDisabled,
    id: "".concat(id, "-label")
    // ExclusiveUnion shenanigans
  }, labelType === 'legend' ? {
    type: labelType
  } : {
    type: labelType,
    htmlFor: hasChildLabel ? id : undefined
  }), label), labelAppend && ' ', labelAppend) : hasEmptyLabelSpace && ___EmotionJSX(EuiSpacer, {
    size: "m",
    className: "euiFormRow__labelWrapper"
  }), ___EmotionJSX("div", {
    className: "euiFormRow__fieldWrapper",
    onFocus: onFocusWithin,
    onBlur: onBlurWithin
  }, field, optionalErrors, optionalHelpTexts));
};
EuiFormRow.propTypes = {
  /**
     * Defaults to rendering a `<label>` but if passed `'legend'` for labelType,
     * will render both a `<legend>` and the surrounding container as a `<fieldset>`
     */
  labelType: PropTypes.oneOfType([PropTypes.oneOf(["label"]), PropTypes.oneOf(["legend"])]),
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
     * - `columnCompressed` creates a compressed and horizontal layout
     * - `center`/`centerCompressed` helps align non-input content better with inline form layouts
     * - `rowCompressed` - **deprecated**, does not currently affect styling
     */
  /**
     * - `columnCompressed` creates a compressed and horizontal layout
     * - `center`/`centerCompressed` helps align non-input content better with inline form layouts
     * - `rowCompressed` - **deprecated**, does not currently affect styling
     */
  display: PropTypes.any,
  /**
     * Useful for inline form layouts, primarily for content that
     * needs to be aligned with inputs but does not need a label
     */
  /**
     * Useful for inline form layouts, primarily for content that
     * needs to be aligned with inputs but does not need a label
     */
  hasEmptyLabelSpace: PropTypes.bool,
  /**
     * Expand to fill 100% of the parent.
     * Defaults to `fullWidth` prop of `<EuiForm>`.
     * @default false
     */
  /**
     * Expand to fill 100% of the parent.
     * Defaults to `fullWidth` prop of `<EuiForm>`.
     * @default false
     */
  fullWidth: PropTypes.bool,
  /**
     * IDs of additional elements that should be part of children's `aria-describedby`
     */
  /**
     * IDs of additional elements that should be part of children's `aria-describedby`
     */
  describedByIds: PropTypes.arrayOf(PropTypes.string.isRequired),
  /**
     * Escape hatch to not render duplicate labels if the child also renders a label
     */
  /**
     * Escape hatch to not render duplicate labels if the child also renders a label
     */
  hasChildLabel: PropTypes.bool,
  /**
     * ReactElement to render as this component's content
     */
  /**
     * ReactElement to render as this component's content
     */
  children: PropTypes.element.isRequired,
  label: PropTypes.node,
  /**
     * Adds an extra node to the right of the form label without
     * being contained inside the form label. Good for things
     * like documentation links.
     */
  /**
     * Adds an extra node to the right of the form label without
     * being contained inside the form label. Good for things
     * like documentation links.
     */
  labelAppend: PropTypes.any,
  id: PropTypes.string,
  isInvalid: PropTypes.bool,
  error: PropTypes.oneOfType([PropTypes.node.isRequired, PropTypes.arrayOf(PropTypes.node.isRequired).isRequired]),
  /**
     *  Adds a single node/string or an array of nodes/strings below the input
     */
  /**
     *  Adds a single node/string or an array of nodes/strings below the input
     */
  helpText: PropTypes.oneOfType([PropTypes.node.isRequired, PropTypes.arrayOf(PropTypes.node.isRequired).isRequired]),
  /**
     *  Passed along to the label element; and to the child field element when `disabled` doesn't already exist on the child field element.
     */
  /**
     *  Passed along to the label element; and to the child field element when `disabled` doesn't already exist on the child field element.
     */
  isDisabled: PropTypes.bool
};