/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS } from '../../../global_styling';
import { euiFormVariables } from '../form.styles';
export var euiFormRowStyles = function euiFormRowStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiFormVariables = euiFormVariables(euiThemeContext),
    maxWidth = _euiFormVariables.maxWidth,
    controlHeight = _euiFormVariables.controlHeight,
    controlCompressedHeight = _euiFormVariables.controlCompressedHeight;
  return {
    euiFormRow: /*#__PURE__*/css("display:flex;+.euiButton{", logicalCSS('margin-top', euiTheme.size.base), ";};label:euiFormRow;"),
    // Skip css`` to avoid generating an Emotion className
    formWidth: "\n      ".concat(logicalCSS('max-width', maxWidth), "\n    "),
    fullWidth: /*#__PURE__*/css(logicalCSS('max-width', '100%'), ";;label:fullWidth;"),
    // Skip css`` to avoid generating an extra className
    row: "\n      flex-direction: column;\n      row-gap: ".concat(euiTheme.size.xs, ";\n\n      .euiFormRow__labelWrapper {\n        display: flex;\n        flex-wrap: wrap;\n        justify-content: space-between;\n      }\n\n      + .euiFormRow {\n        ").concat(logicalCSS('margin-top', euiTheme.size.base), "\n      }\n    "),
    // No difference from the uncompressed row for the current EUI theme
    get rowCompressed() {
      return this.row;
    },
    columnCompressed: /*#__PURE__*/css("flex-direction:row;align-items:stretch;column-gap:", euiTheme.size.s, ";.euiFormRow__label{hyphens:auto;}.euiFormRow__labelWrapper{flex-basis:calc(33% - ", euiTheme.size.s, ");", logicalCSS('min-width', 0), " line-height:", controlCompressedHeight, ";}.euiFormRow__fieldWrapper{flex-basis:67%;", logicalCSS('min-width', 0), ";}+.euiFormRow{", logicalCSS('margin-top', euiTheme.size.s), ";}&:has(.euiSwitch){&:not(:first-child){", logicalCSS('margin-top', euiTheme.size.m), ";}&:not(:last-child){", logicalCSS('margin-bottom', euiTheme.size.m), ";}.euiFormRow__labelWrapper{line-height:", euiTheme.size.base, ";}};label:columnCompressed;"),
    // Center display is primarily for inline form rows, which may have have
    // field content that is shorter than form controls (e.g. switches, text),
    // and should vertically center said content
    centerDisplayCss: function centerDisplayCss(compressed) {
      return "\n      .euiFormRow__fieldWrapper {\n        display: flex;\n        align-items: center;\n        ".concat(logicalCSS('min-height', compressed ? controlCompressedHeight : controlHeight), "\n      }\n    ");
    },
    get center() {
      return /*#__PURE__*/css(this.row, " ", this.centerDisplayCss(false), ";;label:center;");
    },
    get centerCompressed() {
      return /*#__PURE__*/css(this.row, " ", this.centerDisplayCss(true), ";;label:centerCompressed;");
    }
  };
};