var _excluded = ["options", "idSelected", "onChange", "name", "className", "disabled", "compressed", "legend"],
  _excluded2 = ["disabled", "className", "id", "label"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiFormFieldset } from '../form_fieldset';
import { EuiRadio } from './radio';
import { euiRadioGroupStyles } from './radio_group.styles';

// Must omit inherit `onChange` properties or else TS complains when applying to the EuiRadio
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiRadioGroup = function EuiRadioGroup(_ref) {
  var _ref$options = _ref.options,
    options = _ref$options === void 0 ? [] : _ref$options,
    idSelected = _ref.idSelected,
    onChange = _ref.onChange,
    name = _ref.name,
    className = _ref.className,
    disabled = _ref.disabled,
    compressed = _ref.compressed,
    legend = _ref.legend,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiRadioGroup', className);
  var styles = useEuiMemoizedStyles(euiRadioGroupStyles);
  var cssStyles = [styles.euiRadioGroup, compressed ? styles.compressed : styles.uncompressed];
  var radios = options.map(function (option, index) {
    var isOptionDisabled = option.disabled,
      optionClass = option.className,
      id = option.id,
      label = option.label,
      optionRest = _objectWithoutProperties(option, _excluded2);
    return ___EmotionJSX(EuiRadio, _extends({
      className: classNames('euiRadioGroup__item', optionClass),
      key: index,
      name: name,
      checked: id === idSelected,
      disabled: disabled || isOptionDisabled,
      onChange: onChange.bind(null, id, option.value),
      id: id,
      label: label
    }, optionRest));
  });
  if (!!legend) {
    // Be sure to pass down the compressed option to the legend
    legend.compressed = compressed;
    return ___EmotionJSX(EuiFormFieldset, _extends({
      css: cssStyles,
      className: classes,
      legend: legend
    }, rest), radios);
  }
  return ___EmotionJSX("div", _extends({
    css: cssStyles,
    className: classes
  }, rest), radios);
};
EuiRadioGroup.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
     * Passed down to all child `EuiCheckbox`es
     */
  disabled: PropTypes.bool,
  /**
     * Tightens up the spacing between radio rows
     */
  compressed: PropTypes.bool,
  name: PropTypes.string,
  options: PropTypes.arrayOf(PropTypes.shape({
    id: PropTypes.string.isRequired
  }).isRequired).isRequired,
  idSelected: PropTypes.string,
  onChange: PropTypes.func.isRequired,
  /**
     * If the individual labels for each radio do not provide a sufficient description, add a legend.
     * Wraps the group in a `EuiFormFieldset` which adds an `EuiLegend` for titling the whole group.
     * Accepts an `EuiFormLegendProps` shape.
     */
  legend: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any,
    /**
         * ReactNode to render as this component's content
         */
    children: PropTypes.node.isRequired,
    /**
         * For a hidden legend that is still visible to the screen reader, set to 'hidden'
         */
    display: PropTypes.oneOf(["hidden", "visible"]),
    compressed: PropTypes.bool
  })
};