var _excluded = ["className", "showTicks", "lowerPosition", "upperPosition", "onChange", "min", "max", "disabled", "value"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useCallback, useMemo } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useMouseMove, useEuiTheme, useEuiMemoizedStyles } from '../../../services';
import { logicalStyles } from '../../../global_styling';
import { euiRangeDraggableStyles, euiRangeDraggableInnerStyles } from './range_draggable.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiRangeDraggable = function EuiRangeDraggable(_ref) {
  var className = _ref.className,
    showTicks = _ref.showTicks,
    lowerPosition = _ref.lowerPosition,
    upperPosition = _ref.upperPosition,
    onChange = _ref.onChange,
    min = _ref.min,
    max = _ref.max,
    disabled = _ref.disabled,
    value = _ref.value,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = useEuiTheme();
  var outerStyle = useMemo(function () {
    return logicalStyles({
      left: lowerPosition,
      right: "calc(100% - ".concat(upperPosition, " - ").concat(euiTheme.euiTheme.size.base, ")")
    });
  }, [lowerPosition, upperPosition, euiTheme.euiTheme.size.base]);
  var handleChange = useCallback(function (_ref2, isFirstInteraction) {
    var x = _ref2.x;
    if (disabled) return;
    onChange(x, isFirstInteraction);
  }, [disabled, onChange]);
  var _useMouseMove = useMouseMove(handleChange),
    _useMouseMove2 = _slicedToArray(_useMouseMove, 2),
    handleMouseDown = _useMouseMove2[0],
    handleInteraction = _useMouseMove2[1];
  var classes = classNames('euiRangeDraggable', className);
  var styles = useEuiMemoizedStyles(euiRangeDraggableStyles);
  var cssStyles = [styles.euiRangeDraggable, showTicks && styles.hasTicks, disabled && styles.disabled];
  var innerStyles = useEuiMemoizedStyles(euiRangeDraggableInnerStyles);
  var cssInnerStyles = [innerStyles.euiRangeDraggable__inner, disabled ? styles.disabled : innerStyles.enabled];
  var commonProps = {
    className: classes,
    css: cssStyles,
    role: 'slider',
    'aria-valuemin': min,
    'aria-valuemax': max,
    'aria-valuenow': Number(value[0]),
    'aria-valuetext': "".concat(value[0], ", ").concat(value[1]),
    'aria-disabled': !!disabled,
    tabIndex: !!disabled ? -1 : 0
  };
  return ___EmotionJSX("div", _extends({
    style: outerStyle
  }, commonProps, rest), ___EmotionJSX("div", {
    className: "euiRangeDraggable__inner",
    css: cssInnerStyles,
    onMouseDown: handleMouseDown,
    onTouchStart: handleInteraction,
    onTouchMove: handleInteraction
  }));
};
EuiRangeDraggable.propTypes = {
  lowerPosition: PropTypes.string.isRequired,
  upperPosition: PropTypes.string.isRequired,
  onChange: PropTypes.func.isRequired
};