/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiTheme } from '../../../services';
import { logicalStyles } from '../../../global_styling';
import { euiRangeHighlightStyles, euiRangeHighlightProgressStyles, euiRangeHighlightLevelsWrapperStyles, euiRangeHighlightLevelsStyles } from './range_highlight.styles';
import { EuiRangeLevels } from './range_levels';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiRangeHighlight = function EuiRangeHighlight(_ref) {
  var className = _ref.className,
    showTicks = _ref.showTicks,
    trackWidth = _ref.trackWidth,
    lowerValue = _ref.lowerValue,
    upperValue = _ref.upperValue,
    max = _ref.max,
    min = _ref.min,
    background = _ref.background,
    onClick = _ref.onClick,
    levels = _ref.levels;
  // Calculate the width of the range based on value
  var leftPosition = useMemo(function () {
    return (lowerValue - min) / (max - min);
  }, [lowerValue, min, max]);
  var rangeWidth = useMemo(function () {
    return (upperValue - lowerValue) / (max - min);
  }, [upperValue, lowerValue, min, max]);
  var classes = classNames('euiRangeHighlight', className);
  var euiTheme = useEuiTheme();
  var styles = euiRangeHighlightStyles(euiTheme);
  var cssStyles = [styles.euiRangeHighlight, showTicks && styles.hasTicks];
  var progressStyles = euiRangeHighlightProgressStyles(euiTheme);
  var cssProgressStyles = [progressStyles.euiRangeHighlight__progress];
  var progressStyle = useMemo(function () {
    return logicalStyles({
      background: background,
      marginLeft: "".concat(leftPosition * 100, "%"),
      width: "".concat(rangeWidth * 100, "%")
    });
  }, [background, leftPosition, rangeWidth]);
  var levelsWrapperStyles = euiRangeHighlightLevelsWrapperStyles(euiTheme);
  var cssLevelsWrapperStyles = [levelsWrapperStyles.euiRangeHighlight__levelsWrapper];
  var levelsWrapperStyle = useMemo(function () {
    return logicalStyles({
      marginLeft: "".concat(leftPosition * 100, "%"),
      width: "".concat(rangeWidth * 100, "%")
    });
  }, [leftPosition, rangeWidth]);
  var levelsStyles = euiRangeHighlightLevelsStyles(euiTheme);
  var cssLevelsStyles = [levelsStyles.euiRangeHighlight__levels];
  var levelsStyle = useMemo(function () {
    return logicalStyles({
      left: "-".concat(trackWidth * leftPosition, "px"),
      width: "".concat(trackWidth, "px")
    });
  }, [trackWidth, leftPosition]);
  return ___EmotionJSX("div", {
    className: classes,
    css: cssStyles,
    onClick: onClick
  }, (levels && levels.length === 0 || !levels) && ___EmotionJSX("div", {
    "data-test-subj": "euiRangeHighlightProgress",
    className: "euiRangeHighlight__progress",
    css: cssProgressStyles,
    style: progressStyle
  }), levels && !!levels.length && ___EmotionJSX("div", {
    css: cssLevelsWrapperStyles,
    style: levelsWrapperStyle
  }, ___EmotionJSX(EuiRangeLevels, {
    css: cssLevelsStyles,
    style: levelsStyle,
    levels: levels,
    max: max,
    min: min,
    showTicks: showTicks,
    trackWidth: trackWidth
  })));
};
EuiRangeHighlight.propTypes = {
  className: PropTypes.string,
  background: PropTypes.string,
  trackWidth: PropTypes.number.isRequired,
  lowerValue: PropTypes.number.isRequired,
  upperValue: PropTypes.number.isRequired,
  onClick: PropTypes.func
};