/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiFontSize, logicalCSS } from '../../../global_styling';
import { euiRangeVariables } from './range.styles';
export var euiRangeLabelStyles = function euiRangeLabelStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var range = euiRangeVariables(euiThemeContext);
  return {
    euiRangeLabel: /*#__PURE__*/css("font-size:", euiFontSize(euiThemeContext, 'xs').fontSize, ";;label:euiRangeLabel;"),
    min: /*#__PURE__*/css(logicalCSS('padding-right', euiTheme.size.s), ";;label:min;"),
    max: /*#__PURE__*/css(logicalCSS('padding-left', euiTheme.size.s), ";;label:max;"),
    isDisabled: /*#__PURE__*/css("opacity:", range.disabledOpacity, ";;label:isDisabled;")
  };
};