var _excluded = ["levels", "max", "min", "showTicks", "showRange", "trackWidth"],
  _excluded2 = ["color", "className", "min", "max"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo, useEffect } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiTheme } from '../../../services';
import { logicalStyles } from '../../../global_styling';
import { isNamedLevelColor } from './range_levels_colors';
import { euiRangeLevelsStyles, euiRangeLevelStyles } from './range_levels.styles';
import { calculateThumbPosition, EUI_THUMB_SIZE } from './utils';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiRangeLevels = function EuiRangeLevels(_ref) {
  var _ref$levels = _ref.levels,
    levels = _ref$levels === void 0 ? [] : _ref$levels,
    max = _ref.max,
    min = _ref.min,
    showTicks = _ref.showTicks,
    showRange = _ref.showRange,
    trackWidth = _ref.trackWidth,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = useEuiTheme();
  var styles = euiRangeLevelsStyles(euiTheme);
  var cssStyles = [styles.euiRangeLevels, showTicks && styles.hasTicks, showRange && styles.hasRange];
  return ___EmotionJSX("div", _extends({
    className: "euiRangeLevels",
    css: cssStyles
  }, rest), levels.map(function (level, index) {
    return ___EmotionJSX(EuiRangeLevelElement, {
      key: index,
      level: level,
      min: min,
      max: max,
      trackWidth: trackWidth
    });
  }));
};

// Internal subcomponent
EuiRangeLevels.propTypes = {
  trackWidth: PropTypes.number.isRequired,
  style: PropTypes.any
};
var EuiRangeLevelElement = function EuiRangeLevelElement(_ref2) {
  var level = _ref2.level,
    min = _ref2.min,
    max = _ref2.max,
    trackWidth = _ref2.trackWidth;
  var color = level.color,
    className = level.className,
    levelMin = level.min,
    levelMax = level.max,
    levelRest = _objectWithoutProperties(level, _excluded2);
  var isNamedColor = useMemo(function () {
    return isNamedLevelColor(color);
  }, [color]);
  useEffect(function () {
    validateLevelIsInRange({
      min: levelMin,
      max: levelMax
    }, {
      min: min,
      max: max
    });
  }, [levelMin, levelMax, min, max]);
  var styles = useMemo(function () {
    var left = 0;
    var right = 0;
    var leftOffset = 0;
    var rightOffset = 0;
    if (trackWidth > 0) {
      left = levelMin === min ? 0 : calculateThumbPosition(levelMin, min, max, trackWidth);
      leftOffset = calculateOffset(left, levelMin, min);
      right = levelMax === max ? 100 : calculateThumbPosition(levelMax, min, max, trackWidth);
      rightOffset = calculateOffset(right, levelMax, max);
    }
    return logicalStyles({
      left: "calc(".concat(left, "% + ").concat(leftOffset, "px)"),
      right: "calc(".concat(100 - right, "% - ").concat(rightOffset, "px)"),
      backgroundColor: !isNamedColor ? color : undefined
    });
  }, [levelMin, levelMax, min, max, trackWidth, isNamedColor, color]);
  var levelClasses = classNames('euiRangeLevel', className);
  var euiTheme = useEuiTheme();
  var levelStyles = euiRangeLevelStyles(euiTheme);
  var cssLevelStyles = [levelStyles.euiRangeLevel, isNamedColor ? levelStyles[color] : levelStyles.customColor];
  return ___EmotionJSX("span", _extends({
    style: styles,
    className: levelClasses,
    css: cssLevelStyles
  }, levelRest));
};
EuiRangeLevelElement.propTypes = {
  level: PropTypes.shape({
    /**
       * Accepts one of `["primary", "success", "warning", "danger"]` or a valid CSS color value.
       */
    color: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.any.isRequired]).isRequired,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }).isRequired,
  min: PropTypes.any.isRequired,
  max: PropTypes.any.isRequired,
  trackWidth: PropTypes.number.isRequired
};
var validateLevelIsInRange = function validateLevelIsInRange(level, _ref3) {
  var min = _ref3.min,
    max = _ref3.max;
  if (level.min < min) {
    throw new Error("The level min of ".concat(level.min, " is lower than the min value of ").concat(min, "."));
  }
  if (level.max > max) {
    throw new Error("The level max of ".concat(level.max, " is higher than the max value of ").concat(max, "."));
  }
};
var calculateOffset = function calculateOffset(position, value, bound) {
  var threshold = 30;
  var offset = value === bound ? 0 : EUI_THUMB_SIZE / 2;
  if (offset !== 0) {
    // Estimating offset by eye. Trying to account for range scaling at both ends.
    offset = position <= threshold ? offset + 1 / position * threshold : offset;
    offset = position >= 100 - threshold ? offset - 1 / (100 - position) * threshold : offset;
  }
  return offset;
};