/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { transparentize } from '../../../services';
import { euiRangeLevelColor } from './range_levels_colors';
import { euiRangeVariables } from './range.styles';
export var euiRangeLevelsStyles = function euiRangeLevelsStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var range = euiRangeVariables(euiThemeContext);
  var isColorDark = colorMode === 'DARK';
  var stripeColor = isColorDark ? euiTheme.colors.ink : euiTheme.colors.ghost;
  var stripesBackground = "repeating-linear-gradient(\n    -45deg,\n    ".concat(transparentize(stripeColor, 0.5), ",\n    ").concat(transparentize(stripeColor, 0.5), " 25%,\n    ").concat(transparentize(stripeColor, 0.7), " 25%,\n    ").concat(transparentize(stripeColor, 0.7), " 50%,\n    ").concat(transparentize(stripeColor, 0.5), " 50%\n  )");
  return {
    euiRangeLevels: /*#__PURE__*/css("display:flex;justify-content:stretch;position:absolute;inset-inline:0;inset-block-start:", range.trackTopPositionWithoutTicks, ";z-index:", range.levelsZIndex, ";;label:euiRangeLevels;"),
    hasRange: /*#__PURE__*/css("&::after{content:'';position:absolute;block-size:", range.trackHeight, ";inline-size:100%;background-image:", stripesBackground, ";background-size:", euiTheme.size.xs, " ", euiTheme.size.xs, ";border-radius:", range.trackBorderRadius, ";};label:hasRange;"),
    hasTicks: /*#__PURE__*/css("inset-block-start:", range.trackTopPositionWithTicks, ";;label:hasTicks;")
  };
};
export var euiRangeLevelStyles = function euiRangeLevelStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var range = euiRangeVariables(euiThemeContext);
  return {
    euiRangeLevel: /*#__PURE__*/css("display:block;position:absolute;block-size:", range.trackHeight, ";margin-block:0;&:first-child{margin-inline-start:0;border-start-start-radius:", range.trackBorderRadius, ";border-end-start-radius:", range.trackBorderRadius, ";}&:last-child{margin-inline-end:0;border-start-end-radius:", range.trackBorderRadius, ";border-end-end-radius:", range.trackBorderRadius, ";};label:euiRangeLevel;"),
    primary: /*#__PURE__*/css("background-color:", euiRangeLevelColor('primary', euiTheme), ";;label:primary;"),
    success: /*#__PURE__*/css("background-color:", euiRangeLevelColor('success', euiTheme), ";;label:success;"),
    warning: /*#__PURE__*/css("background-color:", euiRangeLevelColor('warning', euiTheme), ";;label:warning;"),
    danger: /*#__PURE__*/css("background-color:", euiRangeLevelColor('danger', euiTheme), ";;label:danger;"),
    customColor: /*#__PURE__*/css(";label:customColor;")
  };
};