var _excluded = ["className", "min", "max", "value", "disabled", "showInput", "showTicks", "onClick", "onMouseDown", "tabIndex"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiTheme } from '../../../services';
import { euiRangeThumbStyles } from './range_thumb.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiRangeThumb = function EuiRangeThumb(_ref) {
  var className = _ref.className,
    min = _ref.min,
    max = _ref.max,
    value = _ref.value,
    disabled = _ref.disabled,
    showInput = _ref.showInput,
    showTicks = _ref.showTicks,
    onClick = _ref.onClick,
    onMouseDown = _ref.onMouseDown,
    tabIndex = _ref.tabIndex,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiRangeThumb', className);
  var euiTheme = useEuiTheme();
  var styles = euiRangeThumbStyles(euiTheme);
  var cssStyles = [styles.euiRangeThumb, showTicks && styles.hasTicks];
  var commonAttrs = {
    className: classes,
    css: cssStyles,
    role: 'slider',
    'aria-valuemin': min,
    'aria-valuemax': max,
    'aria-valuenow': Number(value),
    'aria-disabled': !!disabled,
    tabIndex: showInput || !!disabled ? -1 : tabIndex || 0
  };
  return onClick || onMouseDown ? ___EmotionJSX("button", _extends({
    type: "button",
    onClick: onClick,
    onMouseDown: onMouseDown,
    disabled: disabled
  }, commonAttrs, rest)) : ___EmotionJSX("div", _extends({}, commonAttrs, rest));
};
EuiRangeThumb.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any
};